// ============================================================================
//
// This file is where the Conditions/Actions/Expressions are defined.
// Descriptions and jumptables are at the end of the file.
// If you add another a/c/e don't forget to update them!
//
// ============================================================================

// Common Include
#include	"common.h"


// ============================================================================
//
// CONDITION ROUTINES
// 
// ============================================================================



// ============================================================================
//
// ACTIONS ROUTINES
// 
// ============================================================================



/* startfunc_a: actNavigate */
short WINAPI DLLExport actNavigate(LPRDATA rdPtr, long param1, long param2)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetParameter(rdPtr));	// URL
	if(rdPtr->mWebCtrl!=NULL)
	{
	rdPtr->mWebCtrl->Navigate(p1);
	}
	return 0;
}
/* endfunc_a: actNavigate */
short WINAPI DLLExport actBack(LPRDATA rdPtr,long param1,long param2)
{
	if(rdPtr->mWebCtrl!=NULL)
	{
	rdPtr->mWebCtrl->GoBack();
	}
	return 0;
}
short WINAPI DLLExport actForward(LPRDATA rdPtr,long param1, long param2)
{
	if(rdPtr->mWebCtrl!=NULL)
	{
	rdPtr->mWebCtrl->GoForward();
	}
	return 0;
}
short WINAPI DLLExport actStop(LPRDATA rdPtr,long param1, long param2)
{
	if(rdPtr->mWebCtrl!=NULL)
	{
	rdPtr->mWebCtrl->Stop();
	}
	return 0;
}
short WINAPI DLLExport actRefresh(LPRDATA rdPtr,long param1, long param2)
{
	if(rdPtr->mWebCtrl!=NULL)
	{
	rdPtr->mWebCtrl->Refresh();
	}
	return 0;
}
// ============================================================================
//
// EXPRESSIONS ROUTINES
// 
// ============================================================================



/* startfunc_e: expGetURL */
long WINAPI DLLExport expGetURL(LPRDATA rdPtr, long param1)
{
	rdPtr->rHo.hoFlags |= HOF_STRING;
	char*retStr=NULL;
	if(rdPtr->mWebCtrl!=NULL)
	{
	retStr=rdPtr->mWebCtrl->GetURL();
	}
	else
	{
	retStr="Error";
	}
	// Return string
	return reinterpret_cast<long>(retStr);
}

/* endfunc_e: expGetURL */

// Quick memo: content of the eventInformations arrays
// ---------------------------------------------------
// Menu ID
// String ID
// Code
// Flags
// Number_of_parameters
// Parameter_type [Number_of_parameters]
// Parameter_TitleString [Number_of_parameters]

// Definitions of parameters for each condition
short conditionsInfos[]=
		{
		0
		};

// Definitions of parameters for each action
short actionsInfos[]=
		{
		IDMN_ACTNAVIGATE,	IDS_ACTNAVIGATE,	ACT_ACTNAVIGATE,	0,	1,	PARAM_EXPSTRING,	IDS_ACTNAVIGATE_P0,
		IDMN_ACTBACK, IDS_ACTBACK, ACT_ACTBACK,0,0,
		IDMN_ACTFORWARD,IDS_ACTFORWARD,ACT_ACTFORWARD,0,0,
		IDMN_ACTSTOP,IDS_ACTSTOP,ACT_ACTSTOP,0,0,
		IDMN_ACTREFRESH,IDS_ACTREFRESH,ACT_ACTREFRESH,0,0,
		};

// Definitions of parameters for each expression
short expressionsInfos[]=
		{
		IDMN_EXPGETURL,	IDS_EXPGETURL,	EXP_EXPGETURL,	EXPFLAG_STRING,	0,
		};


// ----------------------------------------------------------
// Condition / Action / Expression jump table
// ----------------------------------------------------------
// Contains the address inside the extension of the different
// routines that handle the action, conditions and expressions.
// Located at the end of the source for convinience
// Must finish with a 0
//
long (WINAPI * ConditionJumps[])(LPRDATA rdPtr, long param1, long param2) = 
			{ 
			0
			};
	
short (WINAPI * ActionJumps[])(LPRDATA rdPtr, long param1, long param2) =
			{
			actNavigate,
			actBack,
			actForward,
			actStop,
			actRefresh,
			0
			};

long (WINAPI * ExpressionJumps[])(LPRDATA rdPtr, long param) = 
			{     
			expGetURL,
			0
			};