// ============================================================================
//
// This file contains routines that are handled during the Runtime.
//
// Including creating, display, and handling your object.
// 
// ============================================================================

// Common Include
#include	"common.h"
// --------------------
// GetRunObjectDataSize
// --------------------
// Returns the size of the runtime datazone of the object
// 
ushort WINAPI DLLExport GetRunObjectDataSize(fprh rhPtr, LPEDATA edPtr)
{
	return(sizeof(RUNDATA));
}


// ---------------
// CreateRunObject
// ---------------
// The routine where the object is actually created
// 
short WINAPI DLLExport CreateRunObject(LPRDATA rdPtr, LPEDATA edPtr, fpcob cobPtr)
{

	rdPtr->LinkVec=new vector<LPRO>;
	rdPtr->PlatVec=new vector<LPRO>;
	rdPtr->SwingVec=new vector<SWING>; 
	rdPtr->setangle=90;
	rdPtr->setlinkspacing=0;
	rdPtr->setgravity=9.81;
	rdPtr->setmass=1;
	rdPtr->setangle=atof(edPtr->setangle);
	rdPtr->setlinkspacing=atof(edPtr->setlinkspacing);
	rdPtr->setgravity=atof(edPtr->setgravity);
	rdPtr->setmass=atof(edPtr->setmass);

	return 0;
}


// ----------------
// DestroyRunObject
// ----------------
// Destroys the run-time object
// 
short WINAPI DLLExport DestroyRunObject(LPRDATA rdPtr, long fast)
{
	delete rdPtr->LinkVec;
	delete rdPtr->PlatVec;
	delete rdPtr->SwingVec;
	return 0;
}


// ----------------
// HandleRunObject
// ----------------
// Called (if you want) each loop, this routine makes the object live
// 
short WINAPI DLLExport HandleRunObject(LPRDATA rdPtr)
{
	int x=0;
	for(x=0;x<rdPtr->SwingVec->size();x++)
	{
		if ((((*rdPtr->SwingVec)[x].anchor)->roHo.hoFlags & HOF_DESTROYED) == HOF_DESTROYED)	
		{
			rdPtr->SwingVec->erase(rdPtr->SwingVec->begin()+x);
		}
		if((*rdPtr->SwingVec)[x].running==TRUE)
		{
			int numlink;
			int length;
			SWING *mySwing;
			LPRO link;
			numlink=floor(rdPtr->LinkVec->size()/rdPtr->SwingVec->size());
			mySwing=&((*rdPtr->SwingVec)[x]);
			mySwing->speed+=mySwing->accel;
			mySwing->angle+=mySwing->speed;
			link=(*rdPtr->LinkVec)[0];
			length=((numlink+1)*(mySwing->linkspacing+link->roHo.hoImgHeight));
			mySwing->accel=-((rdPtr->setgravity*mySwing->mass)/length)*sin(mySwing->angle*(3.14159/180));
			mySwing->oldx=mySwing->x;
			mySwing->oldy=mySwing->y;
			mySwing->x=mySwing->anchor->roHo.hoX+cos((mySwing->angle+90)*(3.14159/180))*length;
			mySwing->y=mySwing->anchor->roHo.hoY+sin((mySwing->angle+90)*(3.14159/180))*length;
			for(int a=0;a<numlink;a++)
			{
				link=(*rdPtr->LinkVec)[x*numlink+a];
				link->roHo.hoX=mySwing->anchor->roHo.hoX+cos((mySwing->angle+90)*(3.14159/180))*((a+1)*(link->roHo.hoImgHeight+mySwing->linkspacing));
				link->roHo.hoY=mySwing->anchor->roHo.hoY+sin((mySwing->angle+90)*(3.14159/180))*((a+1)*(link->roHo.hoImgHeight+mySwing->linkspacing));
				link->roc.rcChanged=1;
			}
			if(x<rdPtr->PlatVec->size())
			{
			link=(*rdPtr->PlatVec)[x];
			link->roHo.hoX=mySwing->x;
			link->roHo.hoY=mySwing->y;
			link->roc.rcChanged=1;
			}
			rdPtr->current=x;
			callRunTimeFunction(rdPtr, RFUNCTION_GENERATEEVENT, 1, 0);
		}
	}
	for(x=0;x<rdPtr->PlatVec->size();x++)
	{
		if(((*rdPtr->PlatVec)[x]->roHo.hoFlags	&	HOF_DESTROYED)==HOF_DESTROYED)
		{
			rdPtr->PlatVec->erase(rdPtr->PlatVec->begin()+x);
		}
	}
	for(x=0;x<rdPtr->LinkVec->size();x++)
	{
		if(((*rdPtr->LinkVec)[x]->roHo.hoFlags & HOF_DESTROYED)==HOF_DESTROYED)
		{
			rdPtr->LinkVec->erase(rdPtr->LinkVec->begin()+x);
		}
	}
return 0;
}
// ----------------
// DisplayRunObject
// ----------------
// Draw the object in the application screen.
// 
short WINAPI DLLExport DisplayRunObject(LPRDATA rdPtr)
{
/*
   If you return REFLAG_DISPLAY in HandleRunObject this routine will run.
   See Graphic_Object_Ex.txt for an example of what you may put here.
*/
	// Ok
	return 0;
}

// ----------------
// PauseRunObject
// ----------------
// Enters the pause mode
// 
short WINAPI DLLExport PauseRunObject(LPRDATA rdPtr)
{
	// Ok
	return 0;
}


// -----------------
// ContinueRunObject
// -----------------
// Quits the pause mode
// 
short WINAPI DLLExport ContinueRunObject(LPRDATA rdPtr)
{
	// Ok
	return 0;
}


// -------------------
// Start/End App/Frame
// -------------------
// Useful for storing global data
// 
#ifdef MMF15EXT

// -------------------
// StartApp
// -------------------
// Called when the application starts or restarts.
// Useful for storing global data
// 
void WINAPI DLLExport StartApp(mv _far *mV, CRunApp* pApp)
{

}

// -------------------
// EndApp
// -------------------
// Called when the application ends.
// 
void WINAPI DLLExport EndApp(mv _far *mV, CRunApp* pApp)
{

}

// -------------------
// StartFrame
// -------------------
// Called when the frame starts or restarts.
// 
void WINAPI DLLExport StartFrame(mv _far *mV, DWORD dwReserved, int nFrameIndex)
{

}

// -------------------
// EndFrame
// -------------------
// Called when the frame ends.
// 
void WINAPI DLLExport EndFrame(mv _far *mV, DWORD dwReserved, int nFrameIndex)
{

}

#endif //MMF1.5 Only