#define IDENTIFIER	0x50534F32

//Routine count definitions

#define	CND_LAST	2
#define	ACT_LAST	16
#define	EXP_LAST        17

_inline int FixedVal(LPRO object)
{ return ((object->roHo.hoCreationId << 16) + object->roHo.hoNumber); }
// --------------------------------
// EDITION OF OBJECT DATA STRUCTURE
// --------------------------------
typedef struct tagEDATA_V1
{
	extHeader		eHeader;
	short			sx;
	short			sy;
	short			swidth;
	short			sheight;
	char setangle[10];
	char setmass[10];
	char setgravity[10];
	char setlinkspacing[10];
	int ancw,anch,platw,plath,linkw,linkh,linkcon;
	bool temp;

} EDITDATA;
typedef EDITDATA _far *			LPEDATA;

// Object versions
#define	KCX_CURRENT_VERSION			1

// --------------------------------
// RUNNING OBJECT DATA STRUCTURE
// --------------------------------
struct SWING
{
	LPRO anchor;
	float mass;
	float angle;
	float speed;
	float linkspacing;
	float oldx;
	float oldy;
	float x;
	float y;
	float accel;
	float oldang;
	bool running;

};
typedef struct tagRDATA
{
	headerObject	rHo;					// Header
	vector<LPRO>*PlatVec;
	vector<LPRO>*LinkVec;
	vector<SWING>*SwingVec;
	float setangle;
	float setmass;
	float setgravity;
	float setlinkspacing;
	int current;
} RUNDATA;
typedef	RUNDATA	_far *			LPRDATA;

// Size when editing the object under level editor
// -----------------------------------------------
#define	MAX_EDITSIZE			sizeof(EDITDATA)

// Default flags
// -------------
#define	OEFLAGS      			0
#define	OEPREFS      			0

// If to handle message, specify the priority of the handling procedure
// 0= low, 255= very high. You should use 100 as normal.                                                
// --------------------------------------------------------------------
#define	WINDOWPROC_PRIORITY		100

 