//Welcome to your auto-generated extension template!
//The first thing you should do is set the active build to debug in the projects menu
//Then build! If there are errors try and find out what caused them
//then check to see it is because of what you typed in in your .aces file

//Use the handy transfer.bat file in the debug directory of the SDK to transfer the cox files to MMF (Close down any projects using the extension first)
//You can get all sorts of crashes if your interface code is wrong so check everything thouroughly or pay later!
//Check each condition, action and expression can be placed and make sure each expression is valid by using the validify button in the expression editor

//If all goes well, happy making!
//What you still need to do :
//	Change the 3 extension build filenames (Project->Settings->V2Template32->Link)
//	Make your icons
//	Make your setup box
//	Fill out your extension info and author info in the string tables
//	Change your version info in the resource file
//	Change your IDENTIFIER, flags and prefrences in main.h
//	Change your runtime data and edittime data structures to suit your needs
//	Fill out all the required routines in Runtime.cpp and Edittime.cpp
//	Flesh out your actions, conditions and expressions
//	Write help files, examples and documentation!



// ============================================================================
//
// This file are where the Conditions/Actions/Expressions are defined.
//
// ============================================================================

// Common Include
#include	"common.h"

// Quick memo: content of the eventInformations arrays
// ---------------------------------------------------
// Menu ID
// String ID
// Code
// Flags
// Number_of_parameters
// Parameter_type [Number_of_parameters]
// Parameter_TitleString [Number_of_parameters]


short conditionsInfos[]=
	{ 
	CID_conIsChainSwing,	CID_conIsChainSwing,	0,	EVFLAGS_ALWAYS | EVFLAGS_NOTABLE,	1,	PARAM_EXPRESSION,	CP0ID_conIsChainSwing,
	CID_conOnSwing,	CID_conOnSwing,	1,	0,	1,PARAM_EXPRESSION,CP0ID_conOnSwing,
		0 };

short actionsInfos[]=
	{ 
	AID_actAddObjAnchor,	AID_actAddObjAnchor,	0,	0,	1,	PARAM_OBJECT,	AP0ID_actAddObjAnchor,
	AID_actAddObjLink,	AID_actAddObjLink,	1,	0,	1,	PARAM_OBJECT,	AP0ID_actAddObjLink,
	AID_actAddObjPlatform,	AID_actAddObjPlatform,	2,	0,	1,	PARAM_OBJECT,	AP0ID_actAddObjPlatform,
	AID_actAnchorSetX,	AID_actAnchorSetX,	3,	0,	2,	PARAM_EXPRESSION,	PARAM_EXPRESSION,	AP0ID_actAnchorSetX,	AP1ID_actAnchorSetX,
	AID_actAnchorSetY,	AID_actAnchorSetY,	4,	0,	2,	PARAM_EXPRESSION,	PARAM_EXPRESSION,	AP0ID_actAnchorSetY,	AP1ID_actAnchorSetY,
	AID_actChainSetMass,	AID_actChainSetMass,	5,	0,	2,	PARAM_EXPRESSION,	PARAM_EXPRESSION,	AP0ID_actChainSetMass,	AP1ID_actChainSetMass,
	AID_actChainAngle,	AID_actChainAngle,	6,	0,	2,	PARAM_EXPRESSION,	PARAM_EXPRESSION,	AP0ID_actChainAngle,	AP1ID_actChainAngle,
	AID_actChainSpeed,	AID_actChainSpeed,	7,	0,	2,	PARAM_EXPRESSION,	PARAM_EXPRESSION,	AP0ID_actChainSpeed,	AP1ID_actChainSpeed,
	AID_actChainSpacing,	AID_actChainSpacing,	8,	0,	2,	PARAM_EXPRESSION,	PARAM_EXPRESSION,	AP0ID_actChainSpacing,	AP1ID_actChainSpacing,
	AID_actStartAll,	AID_actStartAll,	9,	0,	0,
	AID_actStartChain,	AID_actStartChain,	10,	0,	1,	PARAM_EXPRESSION,	AP0ID_actStartChain,
	AID_actStopAll,	AID_actStopAll,	11,	0,	0,
	AID_actStopChain,	AID_actStopChain,	12,	0,	1,	PARAM_EXPRESSION,	AP0ID_actStopChain,
	AID_actUpdateAll,	AID_actUpdateAll,	13,	0,	0,
	AID_actUpdateChain,	AID_actUpdateChain,	14,	0,	1,	PARAM_EXPRESSION,	AP0ID_actUpdateChain,
	AID_actSetAccel,AID_actSetAccel,15,0,2,PARAM_EXPRESSION,PARAM_EXPRESSION,AP0ID_actSetAccel,AP1ID_actSetAccel,
	0 };

short expressionsInfos[]=
	{ 
	EID_expGetNumChain,	EID_expGetNumChain,	0,	0,	0,
	EID_expGetNumLinks,	EID_expGetNumLinks,	1,	0,	0,
	EID_expAnchorX,	EID_expAnchorX,	2,	0,	1,	EXPPARAM_LONG,	0,
	EID_expAnchorY,	EID_expAnchorY,	3,	0,	1,	EXPPARAM_LONG,	0,
	EID_expPlatMass,	EID_expPlatMass,	4,	EXPFLAG_DOUBLE,	1,EXPPARAM_LONG,	0,
	EID_expChainAngle,	EID_expChainAngle,	5,	EXPFLAG_DOUBLE,	1,EXPPARAM_LONG,	0,
	EID_expChainSpeed,	EID_expChainSpeed,	6,	EXPFLAG_DOUBLE,	1,EXPPARAM_LONG,	0,
	EID_expLinkSpacing,	EID_expLinkSpacing,	7,	EXPFLAG_DOUBLE,	1,	EXPPARAM_LONG,	0,
	EID_expPlatformX,	EID_expPlatformX,	8,	0,	1,	EXPPARAM_LONG,	0,
	EID_expPlatformY,	EID_expPlatformY,	9,	0,	1,	EXPPARAM_LONG,	0,
	EID_expChainIndex,EID_expChainIndex,10,0,1,EXPPARAM_LONG,0,
	EID_expDeltaX,EID_expDeltaX,11,0,1,EXPFLAG_DOUBLE,0,
	EID_expDeltaY,EID_expDeltaY,12,0,1,EXPFLAG_DOUBLE,0,
	EID_expAccel,EID_expAccel,13,EXPFLAG_DOUBLE,1,EXPPARAM_LONG,0,
	EID_expLinkIndex,EID_expLinkIndex,14,0,1,EXPPARAM_LONG,0,
	EID_expLinkX,	EID_expLinkX,	15,	0,	2,	EXPPARAM_LONG,	EXPPARAM_LONG,	0,	0,
	EID_expLinkY,	EID_expLinkY,	16,	0,	2,	EXPPARAM_LONG,	EXPPARAM_LONG,	0,	0,
	0 };



//============================================================================
//
// CONDITION ROUTINES
// 
// ============================================================================


long WINAPI DLLExport conIsChainSwing(LPRDATA rdPtr, long param1, long param2)
{
	//param1 contains the number inputed by the user
	return (*rdPtr->SwingVec)[param1].running;
}

long WINAPI DLLExport conOnSwing(LPRDATA rdPtr,long param1,long param2)
{
	if(rdPtr->current==param1)
	{
		return TRUE;
	}
	return FALSE;
}


//============================================================================
//
// ACTIONS ROUTINES
// 
// ============================================================================


short WINAPI DLLExport actAddObjAnchor(LPRDATA rdPtr, long param1, long param2)
{
	LPRO p1=(LPRO)param1; // Caution! RunObject structures vary! See Matt's FAQ
	SWING mySwing;
	mySwing.accel=0;
	mySwing.anchor=p1;
	mySwing.angle=rdPtr->setangle;
	mySwing.linkspacing=rdPtr->setlinkspacing;
	mySwing.mass=rdPtr->setmass;
	mySwing.speed=0;
	mySwing.x=0;
	mySwing.y=0;
	mySwing.running=FALSE;
	rdPtr->SwingVec->push_back(mySwing);
	return 0;
}

short WINAPI DLLExport actAddObjLink(LPRDATA rdPtr, long param1, long param2)
{
	LPRO p1=(LPRO)param1; // Caution! RunObject structures vary! See Matt's FAQ
	rdPtr->LinkVec->push_back(p1);
	return 0;
}

short WINAPI DLLExport actAddObjPlatform(LPRDATA rdPtr, long param1, long param2)
{
	LPRO p1=(LPRO)param1; // Caution! RunObject structures vary! See Matt's FAQ
	rdPtr->PlatVec->push_back(p1);
	return 0;
}

short WINAPI DLLExport actAnchorSetX(LPRDATA rdPtr, long param1, long param2)
{
	//param1 contains the number inputed by the user
	//param2 contains the number inputed by the user
	SWING *mySwing;
	if(param1>=0&&param1<rdPtr->SwingVec->size())
	{
		mySwing=&((*rdPtr->SwingVec)[(int)param1]);
		mySwing->anchor->roHo.hoX=param2;
		mySwing->anchor->roc.rcChanged=1;
	}
	return 0;
}

short WINAPI DLLExport actAnchorSetY(LPRDATA rdPtr, long param1, long param2)
{
	//param1 contains the number inputed by the user
	//param2 contains the number inputed by the user
	SWING *mySwing;
	if(param1>=0&&param1<rdPtr->SwingVec->size())
	{
		mySwing=&((*rdPtr->SwingVec)[(int)param1]);
		mySwing->anchor->roHo.hoY=param2;
		mySwing->anchor->roc.rcChanged=1;
	}
	return 0;
}

short WINAPI DLLExport actChainSetMass(LPRDATA rdPtr, long param1, long param2)
{
	//param1 contains the number inputed by the user
	//param2 contains the number inputed by the user
	long tmpf=CNC_GetFloatValue(rdPtr,1); float p2=*(float *)&tmpf;
	SWING *mySwing;
	if(param1>=0&&param1<rdPtr->SwingVec->size())
	{
		mySwing=&((*rdPtr->SwingVec)[(int)param1]);
		mySwing->mass=p2;
	}
	return 0;
}

short WINAPI DLLExport actChainAngle(LPRDATA rdPtr, long param1, long param2)
{
	//param1 contains the number inputed by the user
	//param2 contains the number inputed by the user
	long tmpf=CNC_GetFloatValue(rdPtr,1); float p2=*(float *)&tmpf;
	SWING *mySwing;
	if(param1>=0&&param1<rdPtr->SwingVec->size())
	{
		mySwing=&((*rdPtr->SwingVec)[(int)param1]);
		mySwing->angle=p2;
	}
	return 0;
}
short WINAPI DLLExport actChainSpeed(LPRDATA rdPtr, long param1, long param2)
{
	//not used
	return 0;
}

short WINAPI DLLExport actChainSpacing(LPRDATA rdPtr, long param1, long param2)
{
	//param1 contains the number inputed by the user
	//param2 contains the number inputed by the user
	SWING *mySwing;
	long tmpf=CNC_GetFloatValue(rdPtr,1); float p2=*(float *)&tmpf;
	if(param1>=0&&param1<rdPtr->SwingVec->size())
	{
		mySwing=&((*rdPtr->SwingVec)[(int)param1]);
		mySwing->linkspacing=(float)p2;
	}
	return 0;
}

short WINAPI DLLExport actStartAll(LPRDATA rdPtr, long param1, long param2)
{
	SWING *mySwing;
	for(int a=0;a<rdPtr->SwingVec->size();a++)
	{
		mySwing=&((*rdPtr->SwingVec)[(int)a]);
		mySwing->running=TRUE;		
	}
	return 0;
}

short WINAPI DLLExport actStartChain(LPRDATA rdPtr, long param1, long param2)
{
	//param1 contains the number inputed by the user
	SWING *mySwing;
	if(param1>=0&&param1<rdPtr->SwingVec->size())
	{
		mySwing=&((*rdPtr->SwingVec)[(int)param1]);
		mySwing->running=TRUE;
	}	
	return 0;
}

short WINAPI DLLExport actStopAll(LPRDATA rdPtr, long param1, long param2)
{
	SWING *mySwing;
	for(int a=0;a<rdPtr->SwingVec->size();a++)
	{
		mySwing=&((*rdPtr->SwingVec)[(int)a]);
		mySwing->running=FALSE;		
	}	
	return 0;
}

short WINAPI DLLExport actStopChain(LPRDATA rdPtr, long param1, long param2)
{
	//param1 contains the number inputed by the user
	SWING *mySwing;
	if(param1>=0&&param1<rdPtr->SwingVec->size())
	{
		mySwing=&((*rdPtr->SwingVec)[(int)param1]);
		mySwing->running=FALSE;
	}
	return 0;
}

short WINAPI DLLExport actUpdateAll(LPRDATA rdPtr, long param1, long param2)
{
	for(int x=0;x<rdPtr->SwingVec->size();x++)
	{
			int numlink;
			int length;
			SWING *mySwing;
			LPRO link;
			numlink=floor(rdPtr->LinkVec->size()/rdPtr->SwingVec->size());
			mySwing=&((*rdPtr->SwingVec)[x]);
			mySwing->speed+=mySwing->accel;
			mySwing->angle+=mySwing->speed;
			link=(*rdPtr->LinkVec)[0];
			length=((numlink+1)*(mySwing->linkspacing+link->roHo.hoImgHeight));
			mySwing->accel=-((rdPtr->setgravity*mySwing->mass)/length)*sin(mySwing->angle*(3.14159/180));
			mySwing->oldx=mySwing->x;
			mySwing->oldy=mySwing->y;
			mySwing->x=mySwing->anchor->roHo.hoX+cos((mySwing->angle+90)*(3.14159/180))*length;
			mySwing->y=mySwing->anchor->roHo.hoY+sin((mySwing->angle+90)*(3.14159/180))*length;
			for(int a=0;a<numlink;a++)
			{
				link=(*rdPtr->LinkVec)[x*numlink+a];
				link->roHo.hoX=mySwing->anchor->roHo.hoX+cos((mySwing->angle+90)*(3.14159/180))*((a+1)*(link->roHo.hoImgHeight+mySwing->linkspacing));
				link->roHo.hoY=mySwing->anchor->roHo.hoY+sin((mySwing->angle+90)*(3.14159/180))*((a+1)*(link->roHo.hoImgHeight+mySwing->linkspacing));
				link->roc.rcDir=((int)(((int)((mySwing->angle*-1)+90))/11.25))%32;
				link->roc.rcChanged=1;
			}
			if(x<rdPtr->PlatVec->size())
			{
			link=(*rdPtr->PlatVec)[x];
			link->roHo.hoX=mySwing->x;
			link->roHo.hoY=mySwing->y;
			link->roc.rcDir=((int)(((int)((mySwing->angle*-1)+90))/11.25))%32;
			link->roc.rcChanged=1;
			}
	}
	return 0;
}

short WINAPI DLLExport actUpdateChain(LPRDATA rdPtr, long param1, long param2)
{
	//param1 contains the number inputed by the user
		if(param1>=0&&param1<rdPtr->SwingVec->size())
		{
			int numlink;
			int length;
			SWING *mySwing;
			LPRO link;
			numlink=floor(rdPtr->LinkVec->size()/rdPtr->SwingVec->size());
			mySwing=&((*rdPtr->SwingVec)[param1]);
			mySwing->speed+=mySwing->accel;
			mySwing->angle+=mySwing->speed;
			link=(*rdPtr->LinkVec)[0];
			length=((numlink+1)*(mySwing->linkspacing+link->roHo.hoImgHeight));
			mySwing->accel=-((rdPtr->setgravity*mySwing->mass)/length)*sin(mySwing->angle*(3.14159/180));
			mySwing->oldx=mySwing->x;
			mySwing->oldy=mySwing->y;
			mySwing->x=mySwing->anchor->roHo.hoX+cos((mySwing->angle+90)*(3.14159/180))*length;
			mySwing->y=mySwing->anchor->roHo.hoY+sin((mySwing->angle+90)*(3.14159/180))*length;
			for(int a=0;a<numlink;a++)
			{
				link=(*rdPtr->LinkVec)[param1*numlink+a];
				link->roHo.hoX=mySwing->anchor->roHo.hoX+cos((mySwing->angle+90)*(3.14159/180))*((a+1)*(link->roHo.hoImgHeight+mySwing->linkspacing));
				link->roHo.hoY=mySwing->anchor->roHo.hoY+sin((mySwing->angle+90)*(3.14159/180))*((a+1)*(link->roHo.hoImgHeight+mySwing->linkspacing));
				link->roc.rcDir=((int)(((int)((mySwing->angle*-1)+90))/11.25))%32;
				link->roc.rcChanged=1;
			}
			if(param1<rdPtr->PlatVec->size())
			{
			link=(*rdPtr->PlatVec)[param1];
			link->roHo.hoX=mySwing->x;
			link->roHo.hoY=mySwing->y;
			link->roc.rcDir=((int)(((int)((mySwing->angle*-1)+90))/11.25))%32;
			link->roc.rcChanged=1;
			}
		}
	return 0;
}
short WINAPI DLLExport actSetAccel(LPRDATA rdPtr, long param1, long param2)
{
	long tmpf=CNC_GetFloatValue(rdPtr,1); 
	float p2=*(float *)&tmpf;
	SWING *mySwing;
	if(param1>=0&&param1<rdPtr->SwingVec->size())
	{
		mySwing=&((*rdPtr->SwingVec)[(int)param1]);
		mySwing->accel=p2;
	}	
	return 0;
}


//============================================================================
//
// EXPRESSIONS ROUTINES
// 
// ============================================================================


long WINAPI DLLExport expGetNumChain(LPRDATA rdPtr, long param1)
{
	return rdPtr->SwingVec->size();
}

long WINAPI DLLExport expGetNumLinks(LPRDATA rdPtr, long param1)
{
	return floor(rdPtr->LinkVec->size()/rdPtr->SwingVec->size());
}

long WINAPI DLLExport expAnchorX(LPRDATA rdPtr, long param1)
{
	long p1=CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_INT);
	SWING *mySwing;
	if(p1>=0&&p1<rdPtr->SwingVec->size())
	{
		mySwing=&((*rdPtr->SwingVec)[(int)p1]);
	}
	return mySwing->anchor->roHo.hoX;
}

long WINAPI DLLExport expAnchorY(LPRDATA rdPtr, long param1)
{
	long p1=CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_INT);
	SWING *mySwing;
	if(p1>=0&&p1<rdPtr->SwingVec->size())
	{
		mySwing=&((*rdPtr->SwingVec)[(int)p1]);
	}
	return mySwing->anchor->roHo.hoY;
}

long WINAPI DLLExport expPlatMass(LPRDATA rdPtr, long param1)
{
	long p1=CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_INT);
	rdPtr->rHo.hoFlags |= HOF_FLOAT;
	SWING *mySwing;
	if(p1>=0&&p1<rdPtr->SwingVec->size())
	{
		mySwing=&((*rdPtr->SwingVec)[(int)p1]);
	}
	return *((long*)(&mySwing->mass));
}

long WINAPI DLLExport expChainAngle(LPRDATA rdPtr, long param1)
{
	long p1=CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_INT);
	rdPtr->rHo.hoFlags |= HOF_FLOAT;	
	SWING *mySwing;
	if(p1>=0&&p1<rdPtr->SwingVec->size())
	{
		mySwing=&((*rdPtr->SwingVec)[(int)p1]);
	} 
	return *((long*)(&mySwing->angle));
}

long WINAPI DLLExport expChainSpeed(LPRDATA rdPtr, long param1)
{
	long p1=CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_INT);
	rdPtr->rHo.hoFlags |= HOF_FLOAT;
	SWING *mySwing;
	if(p1>=0&&p1<rdPtr->SwingVec->size())
	{
		mySwing=&((*rdPtr->SwingVec)[(int)p1]);
	}
	return *((long*)(&mySwing->speed));
}

long WINAPI DLLExport expLinkSpacing(LPRDATA rdPtr, long param1)
{
	long p1=CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_INT);
	rdPtr->rHo.hoFlags |= HOF_FLOAT;	
	SWING *mySwing;
	if(p1>=0&&p1<rdPtr->SwingVec->size())
	{
		mySwing=&((*rdPtr->SwingVec)[(int)p1]);
	}
	return *((long*)(&mySwing->linkspacing));
}

long WINAPI DLLExport expPlatformX(LPRDATA rdPtr, long param1)
{
	long p1=CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_INT);
	LPRO obj;
	if(p1>=0&&p1<rdPtr->PlatVec->size())
	{
		obj=(*rdPtr->PlatVec)[(int)p1];
	}
	return obj->roHo.hoX;
}

long WINAPI DLLExport expPlatformY(LPRDATA rdPtr, long param1)
{
	long p1=CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_INT);
	LPRO obj;
	if(p1>=0&&p1<rdPtr->PlatVec->size())
	{
		obj=(*rdPtr->PlatVec)[(int)p1];
	}
	return obj->roHo.hoY;
}
long WINAPI DLLExport expChainIndex(LPRDATA rdPtr, long param1)
{
	long p1=CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_INT);
	LPRO obj;
	SWING *mySwing;
	for(int a=0;a<rdPtr->PlatVec->size();a++)
	{
		obj=(*rdPtr->PlatVec)[(int)a];
		if(FixedVal(obj)==p1)
		{
			return a;
		}
	}
	for(a=0;a<rdPtr->LinkVec->size();a++)
	{
		obj=(*rdPtr->LinkVec)[(int)a];
		if(FixedVal(obj)==p1)
		{
			return floor(a/floor(rdPtr->LinkVec->size()/rdPtr->SwingVec->size()));
		}
	}
	for(a=0;a<rdPtr->SwingVec->size();a++)
	{
		mySwing=&((*rdPtr->SwingVec)[(int)a]);
		if(FixedVal(mySwing->anchor)==p1)
		{
			return a;
		}
	}
	return -1;
}
   long round(double x) {
	  if((x-floor(x))>=0.5)
	  {
	  return (long)ceil(x);
	  }
	  else
	  {
	  return (long)floor(x);
	  }
   }

long WINAPI DLLExport expDeltaX(LPRDATA rdPtr, long param1)
{
	long p1=CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_INT);
	rdPtr->rHo.hoFlags |= HOF_FLOAT;	
	float Temp;
	SWING *mySwing;
	if(p1>=0&&p1<rdPtr->SwingVec->size())
	{
		mySwing=&((*rdPtr->SwingVec)[(int)p1]);
	}
	if(mySwing->running==true)
	{
	Temp=(mySwing->x)-(mySwing->oldx);
	return *((long*)(&Temp));
	}
	else
	{
	return 0;
	}
}
long WINAPI DLLExport expDeltaY(LPRDATA rdPtr, long param1)
{
	long p1=CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_INT);
	rdPtr->rHo.hoFlags |= HOF_FLOAT;	
	float Temp;
	SWING *mySwing;
	if(p1>=0&&p1<rdPtr->SwingVec->size())
	{
		mySwing=&((*rdPtr->SwingVec)[(int)p1]);
	}
	if(mySwing->running==true)
	{
	Temp=(mySwing->y)-(mySwing->oldy);
	return *((long*)(&Temp));
	}
	else
	{
	return 0;
	}
}
long WINAPI DLLExport expAccel(LPRDATA rdPtr, long param1)
{
	long p1=CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_INT);
	rdPtr->rHo.hoFlags |= HOF_FLOAT;
	SWING *mySwing;
	if(p1>=0&&p1<rdPtr->SwingVec->size())
	{
		mySwing=&((*rdPtr->SwingVec)[(int)p1]);
	}
	if(mySwing->running==true)
	{
	return *((long*)(&mySwing->accel));
	}
	else
	{
	return 0;
	}
}
long WINAPI DLLExport expLinkIndex(LPRDATA rdPtr, long param1)
{
	long p1=CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_INT);
	LPRO obj;
	for(int a=0;a<rdPtr->LinkVec->size();a++)
	{
		obj=(*rdPtr->LinkVec)[(int)a];
		if(FixedVal(obj)==p1)
		{
			return a%(int)(floor(rdPtr->LinkVec->size()/rdPtr->SwingVec->size()));
		}
	}
	return -1;
}
long WINAPI DLLExport expLinkX(LPRDATA rdPtr, long param1)
{
	long p1=CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_INT);
	long p2=CNC_GetNextExpressionParameter(rdPtr, param1, TYPE_INT);
	LPRO obj;
	int numlinks=floor(rdPtr->LinkVec->size()/rdPtr->SwingVec->size());
	if(p1>=0&&p1<rdPtr->SwingVec->size()&&p2>=0&&p2<numlinks)
	{
		obj=(*rdPtr->LinkVec)[(int)p1*numlinks+p2];
		return obj->roHo.hoX;
	}
	return 0;
}
long WINAPI DLLExport expLinkY(LPRDATA rdPtr, long param1)
{
	long p1=CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_INT);
	long p2=CNC_GetNextExpressionParameter(rdPtr, param1, TYPE_INT);
	LPRO obj;
	int numlinks=floor(rdPtr->LinkVec->size()/rdPtr->SwingVec->size());
	if(p1>=0&&p1<rdPtr->SwingVec->size()&&p2>=0&&p2<numlinks)
	{
		obj=(*rdPtr->LinkVec)[(int)p1*numlinks+p2];
		return obj->roHo.hoY;
	}
	return 0;
}
// ----------------------------------------------------------
// Condition / Action / Expression jump table
// ----------------------------------------------------------
// Contains the address inside the extension of the different
// routines that handle the action, conditions and expressions.
// Located at the end of the source for convinience
// Must finish with a 0
//


long (WINAPI * ConditionJumps[])(LPRDATA rdPtr, long param1, long param2) =
	{
	conIsChainSwing,
	conOnSwing,
	0
	};

short (WINAPI * ActionJumps[])(LPRDATA rdPtr, long param1, long param2) =
	{
	actAddObjAnchor,
	actAddObjLink,
	actAddObjPlatform,
	actAnchorSetX,
	actAnchorSetY,
	actChainSetMass,
	actChainAngle,
	actChainSpeed,
	actChainSpacing,
	actStartAll,
	actStartChain,
	actStopAll,
	actStopChain,
	actUpdateAll,
	actUpdateChain,
	actSetAccel,
	0
	};

long (WINAPI * ExpressionJumps[])(LPRDATA rdPtr, long param) =
	{
	expGetNumChain,
	expGetNumLinks,
	expAnchorX,
	expAnchorY,
	expPlatMass,
	expChainAngle,
	expChainSpeed,
	expLinkSpacing,
	expPlatformX,
	expPlatformY,
	expChainIndex,
	expDeltaX,
	expDeltaY,
	expAccel,
	expLinkIndex,
	expLinkX,
	expLinkY,
	0
	};


 