// ============================================================================
//
// This file contains routines that are handled during the Edittime.
//
// Including creating, display, and setting up your object.
// 
// ============================================================================

#ifndef RUN_ONLY

// Common
#include	"common.h"

// Prototype of setup procedure
BOOL CALLBACK DLLExport setupProc(HWND hDlg,uint msgType,WPARAM wParam,LPARAM lParam);

// Structure defined to pass edptr and mv into setup box
typedef struct tagSetP
{
	EDITDATA _far *	edpt;
	mv _far	*		kv;
} setupParams;

/*
// -----------------
// BmpToImg
// -----------------
// Converts an image from the resource to an image displayable under CC&C
// Not used in this template, but it is a good example on how to create
// an image.
WORD BmpToImg(int bmID, npAppli idApp)
{
	Img					ifo;
	WORD				img;
	HRSRC				hs;
	HGLOBAL				hgBuf;
	LPBYTE				adBuf;
	LPBITMAPINFOHEADER	adBmi;

	img = 0;
	if ((hs = FindResource(hInstLib, MAKEINTRESOURCE(bmID), RT_BITMAP)) != NULL)
	{
		if ((hgBuf = LoadResource(hInstLib, hs)) != NULL)
		{
			if ((adBuf = (LPBYTE)LockResource(hgBuf)) != NULL)
			{
				adBmi = (LPBITMAPINFOHEADER)adBuf;
				ifo.imgXSpot = ifo.imgYSpot = ifo.imgXAction = ifo.imgYAction = 0;
				if (adBmi->biBitCount > 4)
					RemapDib((LPBITMAPINFO)adBmi, idApp, NULL);
				img = DibToImage(idApp, &ifo, adBmi);
				UnlockResource(hgBuf);
			}
			FreeResource(hgBuf);
		}
	}
	return img;
}
*/

// --------------------
// PutObject
// --------------------
// Called when each individual object is dropped in the frame.
//
void WINAPI	DLLExport PutObject(mv _far *knpV, fpLevObj loPtr, LPEDATA edPtr, ushort cpt)
{
}

// --------------------
// RemoveObject
// --------------------
// Called when each individual object is removed in the frame.
//
void WINAPI	DLLExport RemoveObject(mv _far *knpV, fpLevObj loPtr, LPEDATA edPtr, ushort cpt)
{
	// Is the last object removed?
    if (0 == cpt)
	{
	// Do whatever necessary to remove our data

	}

}

// --------------------
// MakeIcon
// --------------------
// Called once object is created or modified, just after setup.
//
int WINAPI DLLExport MakeIcon ( mv _far *knpV, BITMAPINFO FAR *lpBitmap, LPSTR lpName, fpObjInfo oiPtr, LPEDATA edPtr )
{
	int					error = -1;
	ushort				pSize, bSize;
	HRSRC				hs;
	HGLOBAL				hgBuf;
	LPBYTE				adBuf;
	LPBITMAPINFOHEADER	adBmi;

	// Here, we simply load the icon from the resource and convert it into a format understood by CC&C.
	// You could also generate the icon yourself from what the user has entered in the setup.
	if ((hs = FindResource(hInstLib, MAKEINTRESOURCE(EXO_ICON), RT_BITMAP)) != NULL)
	{
		if ((hgBuf = LoadResource(hInstLib, hs)) != NULL)
		{
			if ((adBuf = (LPBYTE)LockResource(hgBuf)) != NULL)
			{
				adBmi = (LPBITMAPINFOHEADER)adBuf;
				pSize = (adBmi->biBitCount > 8) ? 0 : (4 << (BYTE) adBmi->biBitCount);
				bSize = (((WORD)adBmi->biWidth * adBmi->biBitCount + 31) &~ 31) / 8 * (WORD)adBmi->biHeight;
				_fmemcpy(lpBitmap, adBuf, sizeof(BITMAPINFOHEADER) + pSize + bSize);
				error = FALSE;
				UnlockResource (hgBuf);
			}
			FreeResource(hgBuf);
		}
	}
	return error;
}

// --------------------
// AppendPopup
// --------------------
// Called just before opening the popup menu of the object under the editor.
// You can remove or add options to the default menu...
void WINAPI DLLExport AppendPopup(mv _far *knpV, HMENU hPopup, fpLevObj loPtr, LPEDATA edPtr, int nbSel)
{
}

// --------------------
// CreateObject
// --------------------
// Called when you choose "Create new object". It should display the setup box 
// and initialize everything in the datazone.

int WINAPI DLLExport CreateObject(mv _far *knpV, fpLevObj loPtr, LPEDATA edPtr)
{
	// Check compatibility
	if ( !IS_COMPATIBLE(knpV) )
		return -1;

	setupParams		spa;

	// Set default object flags
	edPtr->sx = 0;
	edPtr->sy = 0;
	edPtr->swidth = 32;
	edPtr->sheight = 32;
	strcpy(edPtr->setangle,"90");
	strcpy(edPtr->setgravity,"9.81");
	strcpy(edPtr->setlinkspacing,"0");
	strcpy(edPtr->setmass,"1");
	edPtr->ancw=32;
	edPtr->anch=32;
	edPtr->linkw=32;
	edPtr->linkh=32;
	edPtr->platw=64;
	edPtr->plath=32;
	edPtr->linkcon=10;
	edPtr->temp=false;
	// Call setup (remove this and return 0 if your object does not need a setup)
	spa.edpt = edPtr;
	spa.kv = knpV;
	return ((int) DialOpen(hInstLib, MAKEINTRESOURCE(DB_SETUP), knpV->mvHEditWin, setupProc, 0, 0, DL_MODAL|DL_CENTER_WINDOW, (LPARAM)(LPBYTE)&spa));
}

// --------------------
// SelectPopup
// --------------------
// One of the option from the menu has been selected, and not a default menu option
// automatically handled by CC&C: this routine is then called.
//
int WINAPI DLLExport SelectPopup(mv _far *knpV, int modif, fpObjInfo oiPtr, fpLevObj loPtr, LPEDATA edPtr, fpushort lpParams, int maxParams)
{
	// Check compatibility
	if ( !IS_COMPATIBLE(knpV) )
		return 0;

	setupParams		spa;

	// Remove this if your object does not need a setup
	if (modif == ID_POP_SETUP)
	{

		spa.edpt = edPtr;
		spa.kv = knpV;
		if (0 == DialOpen(hInstLib, MAKEINTRESOURCE(DB_SETUP), knpV->mvHEditWin, setupProc, 0, 0, DL_MODAL | DL_CENTER_WINDOW, (LPARAM)(LPBYTE)&spa))
			return MODIF_HFRAN;
	}

/* if your object can be resized, remove the remark!
	if (MODIF_SIZE == modif)
	{
		edPtr->swidth = lpParams[2];
		edPtr->sheight = lpParams[3];
	}
*/
	return 0;
}
// --------------------
// SetupProc
// --------------------
// This routine is yours. You may even not need a setup dialog box.
// I have put it as an example...
BOOL CALLBACK DLLExport setupProc(HWND hDlg,uint msgType,WPARAM wParam,LPARAM lParam)
{
	setupParams	_far *	spa;
	EDITDATA _far *		edPtr;

	switch (msgType)
	{
	case WM_INITDIALOG: // Init dialog
		SetWindowLong(hDlg, DWL_USER, lParam);
		spa = (setupParams far *)lParam;
		edPtr = spa->edpt;
		SetDlgItemText(hDlg,IDC_STARTANG,(char*)(edPtr->setangle));
		SetDlgItemText(hDlg,IDC_MASS,(char*)(edPtr->setmass));
		SetDlgItemText(hDlg,IDC_LINKSPACE,(char*)(edPtr->setlinkspacing));
		SetDlgItemText(hDlg,IDC_GRAVITY,(char*)(edPtr->setgravity));
		SetDlgItemInt(hDlg,IDC_ANCWID,(int)(edPtr->ancw),true);
		SetDlgItemInt(hDlg,IDC_ANCHEI,(int)(edPtr->anch),true);
		SetDlgItemInt(hDlg,IDC_LINKWID,(int)(edPtr->linkw),true);
		SetDlgItemInt(hDlg,IDC_LINKHEI,(int)(edPtr->linkh),true);
		SetDlgItemInt(hDlg,IDC_PLATWID,(int)(edPtr->platw),true);
		SetDlgItemInt(hDlg,IDC_PLATHEI,(int)(edPtr->plath),true);
		SetDlgItemInt(hDlg,IDC_NUMLINK,(int)(edPtr->linkcon),true);
		CheckDlgButton(hDlg,IDC_TEMP,edPtr->temp? BST_CHECKED:BST_UNCHECKED);
		/*
			Insert your code to initalise the dialog!
			Try the following code snippets:

			** Change an editbox's text:

			SetDlgItemText(hDlg, IDC_YOUR_EDITBOX_ID, edPtr->YourTextVariable);

			** (Un)check a checkbox:

			CheckDlgButton(hDlg, IDC_YOUR_CHECKBOX_ID,
				edPtr->YourBooleanValue ? BST_CHECKED : BST_UNCHECKED);
			
			** If the variable is not of type 'bool' then include a comparison
			** before the question mark (conditional operator):

			CheckDlgButton(hDlg, IDC_YOUR_CHECKBOX_ID,
				edPtr->YourLongValue == 1 ? BST_CHECKED : BST_UNCHECKED);

			** Check a radio button, deselecting the others at the same time

			CheckRadioButton(hDlg, IDC_FIRST_RADIO_IN_GROUP, IDC_LAST_RADIO_IN_GROUP, IDC_RADIO_TO_CHECK);

			** You should know how to add radio buttons properly in MSVC++'s dialog editor first...
			** Make sure to add radiobuttons in order, and use the 'Group' property to signal a new group
			** of radio buttons.

			** Disable a control. Replace 'FALSE' with 'TRUE' to enable the control:

			EnableWindow(GetDlgItem(hDlg, IDC_YOUR_CONTROL_ID), FALSE);
		*/
		
		return TRUE;

	case WM_COMMAND: // Command
		spa = (setupParams far *)GetWindowLong(hDlg, DWL_USER);
		edPtr = spa->edpt;

		switch (wmCommandID)
		{
		case IDOK:
			/*
				The user has pressed OK! Save our data with the following commands:

				** Get text from an editbox. There is a limit to how much you can retrieve,
				** make sure this limit is reasonable and your variable can hold this data.
				** (Replace 'MAXIMUM_TEXT_LENGTH' with a value or defined constant!)

				GetDlgItemText(hDlg, IDC_YOUR_EDITBOX_ID, edPtr->YourTextVariable, MAXIMUM_TEXT_LENGTH);

				** Check if a checkbox or radiobutton is checked. This is the basic code:

				(IsDlgButtonChecked(hDlg, IDC_YOUR_CHECKBOX_ID)==BST_CHECKED)

				** This will return true if checked, false if not.
				** If your variable is a bool, set it to this code
				** If not, use an if statement or the conditional operator

				if (IsDlgButtonChecked(hDlg, IDC_YOUR_CHECKBOX_ID)==BST_CHECKED)
					edPtr->YourLongValue = 100;
				else
					edPtr->YourLongValue = 50;
			*/

			// Close the dialog
		GetDlgItemText(hDlg,IDC_STARTANG,(char*)(edPtr->setangle),10);
		GetDlgItemText(hDlg,IDC_MASS,(char*)(edPtr->setmass),10);
		GetDlgItemText(hDlg,IDC_LINKSPACE,(char*)(edPtr->setlinkspacing),10);
		GetDlgItemText(hDlg,IDC_GRAVITY, (char*)(edPtr->setgravity),10);
		edPtr->ancw=GetDlgItemInt(hDlg,IDC_ANCWID,NULL,true);
		edPtr->anch=GetDlgItemInt(hDlg,IDC_ANCHEI,NULL,true);
		edPtr->linkw=GetDlgItemInt(hDlg,IDC_LINKWID,NULL,true);
		edPtr->linkh=GetDlgItemInt(hDlg,IDC_LINKHEI,NULL,true);
		edPtr->platw=GetDlgItemInt(hDlg,IDC_PLATWID,NULL,true);
		edPtr->plath=GetDlgItemInt(hDlg,IDC_PLATHEI,NULL,true);
		edPtr->linkcon=GetDlgItemInt(hDlg,IDC_NUMLINK,NULL,true);
		edPtr->temp=IsDlgButtonChecked(hDlg, IDC_TEMP);
		EndDialog(hDlg, 0);
			return 0;

		case IDCANCEL:
			// User pressed cancel, don't save anything
			// Close the dialog
			EndDialog(hDlg, -1);
			return 0;

		case ID_HELP:
			{
				/* This code will run if the Help button is clicked.
				   If you have just a text file, try this:
				   (Paths relative to MMFusion.exe, don't forget to escape the backslashes!)

				ShellExecute(NULL, "open", "notepad",
					"Docs\\My Extension\\ThisIsMyDocumentation.txt",
					NULL, SW_MAXIMIZE);

				   If you have a document for which the program you use can be different
				   (for example, an HTML document or .doc) then try this form:

				ShellExecute(NULL, "open", "Docs\\My Extension\\MyDocs.html",
					NULL, NULL, SW_MAXIMIZE);

				   If you use the ShellExecute function you must include the library
				   'shell32.lib' in your Release_Small config. To do this, go to menu
				   Project > Settings, choose 'Win32 Release_Small' on the upper-left,
				   click the 'Link' tab on the right and enter "shell32.lib" (w/o quotes)
				   at the end of the 'Object/library modules' editbox. Ensure there is a
				   space between this and the rest of the line. If you don't do this, you
				   will get 'unresolved external' errors because the compiler cannot find
				   the function when it links the different .cpp files together.

				*/



				/* This is useful if your extension is documented in the MMF help file...
				// (In other words, you'll never need it, but it was SDK's default action)
				NPSTR	chTmp;
				if ((chTmp = (NPSTR)LocalAlloc(LPTR, _MAX_PATH)) != NULL)
				{
					GetModuleFileName(hInstLib, chTmp, _MAX_PATH);
					spa->kv->mvKncHelp(chTmp, HELP_CONTEXT, 1);
					LocalFree((HLOCAL)chTmp);
				}
				*/
			}
			return 0;

		/*
			If you have a button or checkbox which, when clicked, will change
			something on the dialog, add them like so:

		case IDC_YOUR_CLICKED_CONTROL:
			// your code here
			return 0;

			You can use any of the commands added previously, (including the Help code,)
			but it's a good idea NOT to save data to edPtr until the user presses OK.
		*/

		default:
			break;
		}
		break;

	default:
		break;
	}
	return FALSE;
}


// --------------------
// ModifyObject
// --------------------
// Called by CC&C when the object has been modified
//
int WINAPI DLLExport ModifyObject(mv _far *knpV, LPEDATA edPtr, fpObjInfo oiPtr, fpLevObj loPtr, int modif, fpushort lpParams)
{
	
	// Modification in size?
	if (MODIF_SIZE == modif)
	{
		edPtr->swidth = lpParams[2];
		edPtr->sheight = lpParams[3];
	}
	// No errors...
	return 0;
}


// --------------------
// RebuildExt
// --------------------
// This routine rebuilds the new extension datazone from the old one, and the
// modifications done in the setup dialog
int WINAPI DLLExport RebuildExt(mv _far *knpV, LPEDATA edPtr, LPBYTE oldExtPtr, fpObjInfo oiPtr, fpLevObj loPtr, fpushort lpParams)
{
	// No errors
	return 0;	
}


// --------------------
// EndModifyObject
// --------------------
// After all modifications are done, this routine is called.
// You can free any memory allocated here.
void WINAPI DLLExport EndModifyObject(mv _far *knpV, int modif, fpushort lpParams)
{
}

// --------------------
// GetObjectRect
// --------------------
// Returns the size of the rectangle of the object in the frame window
//
void WINAPI DLLExport GetObjectRect(mv _far *knpV, RECT FAR *rc, fpLevObj loPtr, LPEDATA edPtr)
{
	//Print("GetObjectRect");
	rc->right = rc->left + edPtr->swidth;
	rc->bottom = rc->top + edPtr->sheight;
	return;
}


// --------------------
// EditorDisplay
// --------------------
// Displays the object under the frame editor
//
void WINAPI DLLExport EditorDisplay(mv _far *knpV, fpObjInfo oiPtr, fpLevObj loPtr, LPEDATA edPtr, RECT FAR *rc)
{
	
/* This is a simple case of drawing an image onto MMF's frame editor window
First, we must get a pointer to the surface used by the frame editor
	*/
	
	LPSURFACE ps = WinGetSurface((int)knpV->mvIdEditWin);
	if ( ps != NULL )		// Do the following if this surface exists
	{
		int linksp,grav,sang,mass,ang,length,ancx,ancy,platx,platy,linkx,linky;
		
		linksp=atof(edPtr->setlinkspacing);
		sang=atof(edPtr->setangle);
		ang=sang;
		length=((edPtr->linkcon+1)*(linksp+edPtr->linkh));
		if(edPtr->temp==true)
		{
			edPtr->swidth=(length)*2+edPtr->platw;
			edPtr->sheight=(length)*2+edPtr->plath;
		}
		if(edPtr->temp==false)
		{
			edPtr->swidth=32;
			edPtr->sheight=32;
		}
		GetObjectRect(knpV,rc,loPtr,edPtr);
		
		int x = rc->left;	// get our boundaries
		int y = rc->top;
		int w = rc->right-rc->left;
		int h = rc->bottom-rc->top;
		if(edPtr->temp==false)
		{
			cSurface is;		
			is.Create(4, 4, ps);	
			is.LoadImage(hInstLib, EXO_IMAGE, LI_REMAP);	
			
			is.Blit(*ps, x, y, BMODE_TRANSP, BOP_COPY, 0);
		}
		if(edPtr->temp==true)
		{
			//	ps->Fill(x,y,w,h,255,255,255);
			ancx=x+w/2;
			ancy=y+h/2;
			ps->Rectangle(ancx-edPtr->ancw/2,ancy-edPtr->anch/2,ancx+edPtr->ancw/2,ancy+edPtr->anch/2,RGB(255,0,0),0,RGB(0,0,0),TRUE);
			char buffer[50];
			sprintf(buffer,"(%i,%i)",ancx-edPtr->ancw/2,ancy-edPtr->anch/2);
			RECT *myRec;
			myRec=new RECT();
			myRec->left=ancx-edPtr->ancw/2;
			myRec->right=myRec->left+edPtr->ancw*2;
			myRec->top=ancy-edPtr->anch/2;
			myRec->bottom=myRec->top+edPtr->anch*2;
			ps->DrawText(buffer,-1,myRec,DT_CENTER,RGB(0,0,0));
			delete myRec;
			for(int a=-1;a<=1;a++)
			{
				ang=a*sang;
				platx=ancx+cos((ang+90)*(3.14159/180))*length;
				platy=ancy+sin((ang+90)*(3.14159/180))*length;
				ps->Rectangle(platx-edPtr->platw/2,platy-edPtr->plath/2,platx+edPtr->platw/2,platy+edPtr->plath/2,RGB(255,0,0),0,RGB(0,0,0),TRUE);
				char buffer[50];
				sprintf(buffer,"(%i,%i)",platx,platy);
				RECT *myRec;
				myRec=new RECT();
				myRec->left=platx-edPtr->platw;
				myRec->right=myRec->left+edPtr->platw*2;
				myRec->top=platy-edPtr->plath/2;
				myRec->bottom=myRec->top+edPtr->plath*2;
				
				ps->DrawText(buffer,-1,myRec,DT_CENTER,RGB(0,0,0));
				delete myRec;
			}
			WinAddZone(knpV->mvIdEditWin, rc);
			
		}
	}
}


// --------------------
// IsTransparent
// --------------------
// This routine tells CC&C if the mouse pointer is over a transparent zone of the object.
// 

extern "C" {
	BOOL WINAPI DLLExport IsTransparent(mv _far *knpV, fpLevObj loPtr, LPEDATA edPtr, int dx, int dy)
	{
		return FALSE;
	}
}

// --------------------
// PrepareToWriteObject
// --------------------
// Just before writing the datazone when saving the application, CC&C calls this routine.
// 
void WINAPI	DLLExport PrepareToWriteObject(mv _far *knpV, LPEDATA edPtr, fpObjInfo adoi)
{
}

// --------------------
// UsesFile
// --------------------
// Triggers when a file is dropped onto the frame
BOOL WINAPI DLLExport UsesFile (LPMV mV, LPSTR fileName)
{
	
	// Return TRUE if you can create an object from the given file
	return FALSE;

	// Example: return TRUE if file extension is ".txt"
/*	BOOL	r = FALSE;
	NPSTR	ext, npath;

	if ( fileName != NULL )
	{
		if ( (ext=(NPSTR)LocalAlloc(LPTR, _MAX_EXT)) != NULL )
		{
			if ( (npath=(NPSTR)LocalAlloc(LPTR, _MAX_PATH)) != NULL )
			{
				_fstrcpy(npath, fileName);
				_splitpath(npath, NULL, NULL, NULL, ext);
				if ( _stricmp(ext, ".txt") == 0 )
					r = TRUE;
				LocalFree((HLOCAL)npath);
			}
			LocalFree((HLOCAL)ext);
		}
	}
	return r; */
}


// --------------------
// CreateFromFile
// --------------------
// Creates a new object from file
void WINAPI DLLExport CreateFromFile (LPMV mV, LPSTR fileName, LPEDATA edPtr) 
{
	// Initialize your extension data from the given file
	edPtr->swidth = 32;
	edPtr->sheight = 32;

	// Example: store the filename
	// _fstrcpy(edPtr->myFileName, fileName);
}



#endif //Not RUN_ONLY
