#ifndef PHYSICSWORLD_H
#define PHYSICSWORLD_H

#include <ode/ode.h>
#include <flatland/shapes.hpp>
#include <flatland/flatland.hpp>
#include <deque>
#include <stack>
#include <string>

using Flatland::vec2;
using Flatland::Dynamic;
using Flatland::Static;
using Flatland::round;
using Flatland::pi;
using Flatland::aabb;
using Flatland::ContactList;

class Space;

class Object //Flatland object wrapper
{
public:
	Object(){};
	virtual ~Object() {mID="";}
	virtual void Draw() const = 0;
	virtual Flatland::Object *GetFlatlandObject() { return 0; }
	virtual void Insert(Space &space);
	virtual void InsertFront(Space &space);
	std::string GetID(){return mID;}
	void SetID(std::string pID){mID=pID;}
	virtual void SetPosition(vec2 pPos){};
	virtual void SetCenter(vec2 pCenter){};
	virtual void SetPrivateData(void*tData){};
	virtual void* GetPrivateData(){return NULL;};
	virtual void Add(Flatland::Geometry *geometry,std::string pGeomID){};
	virtual void Remove(std::string pGeomID){};
	virtual void CollisionCallback(ContactList &contacts){};
protected:
	std::string mID;
};

typedef std::deque<Object*> OList; 

class Space //space class
{
public:
	~Space();
	size_t size() const { return list.size(); }
	Space &operator<<(Object *o) { list.push_back(o); return *this; }
	typedef OList::const_iterator const_iterator;
	const_iterator begin() const { return list.begin(); }
	const_iterator end() const { return list.end(); }
	void pop() { delete *m; m = list.erase(m); }
	void push_back(Object *o) { list.push_back(o); }
	void push_front(Object *o) { list.push_front(o); }
	void mark() { m = --list.end(); }
	Object*GetSObject(int pIndex);
	void SortObjLst();
	Object* FindObj(std::string pName);
private:
	OList list;
	OList::iterator m;

};

class Line : public Object
{
public:
	Line(vec2 a, vec2 b);
	void Draw() const;
	Flatland::Object *GetFlatlandObject() { return &object; }
private:
	Static<Flatland::Line> object;
};

class Terrain: public Object
{
public:
	Terrain(vec2 pstartpos,int pwidth,int pheight);
	void BuildBorders(Space &space);
	void Draw() const;
	Flatland::Object *GetFlatlandObject() { return &object; }
private:
	Static<Flatland::Terrain> object;
	int mWidth,mHeight;
	vec2 mStartPos;
	Line*TopBorder;
	Line*BottomBorder;
	Line*RightBorder;
	Line*LeftBorder;
};
class PhysicsWorld
{
public:
	PhysicsWorld();
	~PhysicsWorld();
	void InitODE();
	void Step(float delta);
	Flatland::World &GetWorld();
	Space &GetSpace();
	virtual void Draw() const;
protected:
	Space space;
	Flatland::World world;
	Terrain*mTerrain;
};



#endif