#include "PhysicsWorld.h"

Space::~Space()
{
	for (m = list.begin(); m != list.end(); ++m)
		delete *m;
}
Object* Space::GetSObject(int pIndex)
{
	if(pIndex>=0&&pIndex<list.size())
		return list[pIndex];
	else
		return NULL;
}
Object* Space::FindObj(std::string pName)
{
	int first,last,mid;
	first=0;
	last=list.size();
	if(last>0)
	{
		while(first<=last)
		{
			mid=(first+last)/2;
			Object*tObj=GetSObject(mid);
			if(tObj!=NULL)
			{
				if(pName>tObj->GetID())
					first=mid+1;
				else if(pName<tObj->GetID())
					last=mid-1;
				else
					return tObj;
			}
			else
				break;
		}
	}
	return NULL;
}
void Space::SortObjLst()
{
	int i, j, mi;
	Object*temp;
	int end = list.size()- 1;
	for (i = 0; i < end; i++) 
	{
		mi = i;
		for (j = i+1; j <(signed)list.size(); j++) 
		{
			if (GetSObject(j)->GetID() < GetSObject(mi)->GetID()) 
			{
				mi = j;
			}
		}
		temp= GetSObject(i);
		list[i]=GetSObject(mi);
		list[mi]=temp;
	}
}
void Object::Insert(Space&space)
{
	space.push_back(this);
}
void Object::InsertFront(Space&space)
{
	space.push_front(this);
}
Line::Line(vec2 a,vec2 b):object(new Flatland::Line(a,b))
{
}
void Line::Draw() const
{
}

Terrain::Terrain(vec2 pstartpos,int pwidth,int pheight):object(new Flatland::Terrain(pstartpos))
{
	mWidth=pwidth;
	mHeight=pheight;
	mStartPos=pstartpos;
	TopBorder=NULL;
	BottomBorder=NULL;
	RightBorder=NULL;
	LeftBorder=NULL;
	SetID("Border");
}
void Terrain::BuildBorders(Space &space)
{
	object.GetGeometry().Finalize();
	TopBorder=new Line(vec2(mStartPos.x,mStartPos.y),vec2(mStartPos.x+mWidth,mStartPos.y));
	TopBorder->SetID("Border_1");
	TopBorder->Insert(space);
	BottomBorder=new Line(vec2(mStartPos.x,mStartPos.y+mHeight),vec2(mStartPos.x+mWidth,mStartPos.y+mHeight));
	BottomBorder->SetID("Border_2");
	BottomBorder->Insert(space);
	RightBorder=new Line(vec2(mStartPos.x+mWidth,mStartPos.y),vec2(mStartPos.x+mWidth,mStartPos.y+mHeight));
	RightBorder->SetID("Border_3");
	RightBorder->Insert(space);
	LeftBorder=new Line(vec2(mStartPos.x,mStartPos.y),vec2(mStartPos.x,mStartPos.y+mHeight));
	LeftBorder->SetID("Border_4");
	LeftBorder->Insert(space);
	//Line*tLine=new Line(vec2(mStartPos.x,mStartPos.y+mHeight/2),vec2(mStartPos.x+mWidth/2,mStartPos.y+mHeight));
	//tLine->SetID("Border_Ramp");
	//tLine->Insert(space);
	Object::Insert(space);
}
void Terrain::Draw() const
{
}
PhysicsWorld::PhysicsWorld()
{
	InitODE();
	mTerrain=new Terrain(vec2(0,0),640,480);
	mTerrain->BuildBorders(space);
}
PhysicsWorld::~PhysicsWorld()
{
}
void PhysicsWorld::Draw() const
{
	for (Space::const_iterator i = space.begin(); i != space.end(); ++i)
		(*i)->Draw();
}
void PhysicsWorld::InitODE()
{
	world.SetCFM(0);
	world.SetAutoDisableFlag(false);
	world.SetAutoDisableLinearThreshold(0.25f);
	world.SetERP(0.2f);
	world.SetContactMaxCorrectingVel(1);
	world.SetContactSurfaceLayer(0.01f);
	world.SetGravity(vec2(0,10.0f));
}
void PhysicsWorld::Step(float delta)
{
	world.GenerateContacts(space);
	world.QuickStep(delta);
	assert(world.IsCorrupt(space));
}
Flatland::World &PhysicsWorld::GetWorld()
{
	return world;
}
Space &PhysicsWorld::GetSpace()
{
	return space;
}