// Object identifier "SAM2"
#define IDENTIFIER	MAKEID(v,f,d,e)
#include "PhysicsWorld.h"
#include <vector>

using namespace std;

// ------------------------------
// DEFINITION OF CONDITIONS CODES
// ------------------------------
#define CND_CONONOBJ                   0
#define CND_CONONCOLLISION             1
#define CND_CONOBJENABLED              2
#define CND_CONONERROR                 3

#define	CND_LAST					4

// ---------------------------
// DEFINITION OF ACTIONS CODES
// ---------------------------
#define ACT_ACTLOADWORLD               0
#define ACT_ACTADDOBJECT               1
#define ACT_ACTSETGLOBALERP            2
#define ACT_ACTSETGLOBALCFM            3
#define ACT_ACTSETGRAVITY              4
#define ACT_ACTSETBORDERFLAG           5
#define ACT_ACTSETAUTOUPDATEFLAG       6
#define ACT_ACTUPDATEWORLD             7
#define ACT_ACTADDBOXTOOBJ             8
#define ACT_ACTADDCIRCLETOOBJ          9
#define ACT_ACTSETOBJCENTER            10
#define ACT_ACTREMOVEPRIMITIVE         11
#define ACT_ACTSETACTIVE               12
#define ACT_ACTSETOBJX                 13
#define ACT_ACTSETOBJY                 14
#define ACT_ACTSETOBJANGLE             15
#define ACT_ACTSETOBJANGVEL            16
#define ACT_ACTSETOBJLINVEL            17
#define ACT_ACTSETOBJMASS              18
#define ACT_ACTSETOBJGRAVITYMODE       19
#define ACT_ACTSETOBJBOUNCECOEFF       20
#define ACT_ACTSETOBJFRICTIONCOEFF     21
#define ACT_ACTSETOBJSOFTCOEFF         22
#define ACT_ACTSETOBJAUTODISABLEFLAG   23
#define ACT_ACTSETOBJSTATICFLAG        24
#define ACT_ACTSETOBJENABLEDFLAG       25
#define ACT_ACTADDOBJFORCE             26
#define ACT_ACTADDOBJRELFORCE          27
#define ACT_ACTADDOBJTORQUE            28
#define ACT_ACTADDOBJRELTORQUE         29
#define ACT_ACTADDSLIDERJOINT          30
#define ACT_ACTADDHINGEJOINT           31
#define ACT_ACTSETJOINTRIGIDITY        32
#define ACT_ACTREMOVEJOINT             33
#define ACT_ACTCLEARERROR              34

#define	ACT_LAST					35

// -------------------------------
// DEFINITION OF EXPRESSIONS CODES
// -------------------------------
#define EXP_EXPGETID                   0
#define EXP_EXPGETERP                  1
#define EXP_EXPGETCFM                  2
#define EXP_EXPGETGRAVX                3
#define EXP_EXPGETGRAVY                4
#define EXP_EXPGETBORDERSTATE          5
#define EXP_EXPGETAUTOUPSTATE          6
#define EXP_EXPGETOBJXCENTER           7
#define EXP_EXPGETOBJYCENTER           8
#define EXP_EXPGETOBJXPOS              9
#define EXP_EXPGETOBJYPOS              10
#define EXP_EXPGETOBJANG               11
#define EXP_EXPGETOBJANGVELX           12
#define EXP_EXPGETOBJANGVELY           13
#define EXP_EXPGETOBJLINVELX           14
#define EXP_EXPGETOBJLINVELY           15
#define EXP_EXPGETOBJMASS              16
#define EXP_EXPGETOBJGRAVMODE          17
#define EXP_EXPGETOBJBOUNCECOEFF       18
#define EXP_EXPGETOBJFRICCOEFF         19
#define EXP_EXPGETOBJSOFTCOEFF         20
#define EXP_EXPGETOBJAUTODISABLESTATE  21
#define EXP_EXPGETOBJSTATICSTATE       22
#define EXP_EXPGETOBJENABLESTATE       23
#define EXP_EXPGETJOINTCOUNT           24
#define EXP_EXPGETJOINTSPRINGCONSTANT  25
#define EXP_EXPGETJOINTDAMPINGCONSTANT 26
#define EXP_EXPGETERRORMESSAGE         27

#define	EXP_LAST					28

// --------------------------------
// EDITION OF OBJECT DATA STRUCTURE
// --------------------------------
// These values let you store data in your extension that will be saved in the CCA.
// You would use these with a dialog...

typedef struct tagEDATA_V1
{
	extHeader		eHeader;
	//	short			swidth;
	//	short			sheight;

	// Properties


} EDITDATA;
typedef EDITDATA _far *			LPEDATA;

// Object versions
#define	KCX_CURRENT_VERSION			1

// --------------------------------
// RUNNING OBJECT DATA STRUCTURE
// --------------------------------
// If you want to store anything between actions/conditions/expressions
// you should store it here. Also, some OEFLAGS require you to add
// structures to this structure.



typedef struct tagRDATA
{
	headerObject	rHo;					// Header
	PhysicsWorld*mWorld;
	std::string FirstID;
	std::string SecondID;
	std::string Error;
} RUNDATA;
typedef	RUNDATA	_far *			LPRDATA;


class FusionObj: public Object
{
public:
	FusionObj(Flatland::World &pWorld,vec2 centroid);
	void Draw() const;
	Flatland::Object *GetFlatlandObject() { return &object; }
    virtual void Insert(Space &space);
    virtual void InsertFront(Space &space);
	void Add(Flatland::Geometry *geometry,std::string pGeomID);
	void Remove(std::string pGeomID);
	void SetPosition(vec2 pPos);
	void SetCenter(vec2 pCenter);
	void SetPrivateData(void*tData);
	void* GetPrivateData();
	static void fustaticCallback(ContactList &contacts);
	void CollisionCallback(ContactList &contacts);
private:
	LPRO mObj;
	Dynamic<Flatland::Composite> object;
};

// Size when editing the object under level editor
// -----------------------------------------------
#define	MAX_EDITSIZE			sizeof(EDITDATA)

// Default flags
// -------------
#define	OEFLAGS      			0
#define	OEPREFS      			0

/* See OEFLAGS.txt for more info on these useful things! */


// If to handle message, specify the priority of the handling procedure
// 0= low, 255= very high. You should use 100 as normal.                                                
// --------------------------------------------------------------------
#define	WINDOWPROC_PRIORITY		100
