// ============================================================================
//
// This file is where the Conditions/Actions/Expressions are defined.
// Descriptions and jumptables are at the end of the file.
// If you add another a/c/e don't forget to update them!
//
// ============================================================================

// Common Include
#include	"common.h"
LPRDATA mrFData; 
FusionObj::FusionObj(Flatland::World &pWorld,vec2 centroid):object(new Flatland::Composite(centroid),pWorld.BodyCreate())
{
	mObj=NULL;
}
void FusionObj::SetPrivateData(void*tData)
{
	mObj=(LPRO)tData;
}
void* FusionObj::GetPrivateData()
{
	return (void*)mObj;
}

void FusionObj::Draw() const
{
	const Flatland::Composite &geom = object.GetGeometry();
	const vec2 &center = geom.Center();
	const dReal epsilon=0.0000001;
	float mAng=0;
	if(	object.body->R[2] < 1-epsilon && 	object.body->R[2] > -1+epsilon)
	{
		dReal c=cos(-asin(	object.body->R[2]));
		mAng= atan2(	object.body->R[1]/c,object.body->R[0]/c);
	} 
	else 
	{       
		mAng=0;   
	}     	

	if(mObj!=NULL)
	{

		mObj->roHo.hoX=center.x;
		mObj->roHo.hoY=center.y;
		mObj->roc.rcAngle=(mAng*(180/3.14159));
		mObj->roc.rcChanged=1;
	}

}
void FusionObj::Insert(Space &space)
{
	object.GetGeometry().Finalize();
	Object::Insert(space);
}
void FusionObj::InsertFront(Space &space)
{
	object.GetGeometry().Finalize();
	Object::InsertFront(space);
}
void FusionObj::Add(Flatland::Geometry *geometry,std::string pGeomID)
{
	geometry->SetID(pGeomID);
	object.GetGeometry().push_back(geometry);
}
void FusionObj::SetPosition(vec2 pPos)
{
	object.SetCenter(pPos);
}
void FusionObj::SetCenter(vec2 pCenter)
{
	Flatland::Composite &geom = object.GetGeometry();
	geom.SetCenter(pCenter);
	geom.UpdateBounds();
}
void FusionObj::Remove(std::string pGeomID)
{
	const Flatland::Composite &geom = object.GetGeometry();
	Flatland::Geometry *tGeom=NULL;
	for (Flatland::Composite::const_iterator g = geom.begin(); g != geom.end(); ++g)
	{
		if((**g).GetID()==pGeomID)
		{
			tGeom=*g;
		}
	}
	if(tGeom!=NULL)
		object.GetGeometry().RemoveGeometry(tGeom);
}
void FusionObj::fustaticCallback(ContactList &contacts)
{
	Object*tObj=NULL;
	for(int i=0;i<mrFData->mWorld->GetSpace().size();i++)
	{
		tObj=mrFData->mWorld->GetSpace().GetSObject(i);
		if(tObj->GetFlatlandObject()==contacts.Self())
			break;
	}
	if(tObj!=NULL)
		tObj->CollisionCallback(contacts);
}
void FusionObj::CollisionCallback(ContactList &contacts)
{
	std::string otherID;
	for(int i=0;i<mrFData->mWorld->GetSpace().size();i++)
	{
		if(mrFData->mWorld->GetSpace().GetSObject(i)->GetFlatlandObject()==contacts.Other())
		{
			otherID=mrFData->mWorld->GetSpace().GetSObject(i)->GetID();
			break;
		}
	}
	mrFData->FirstID=GetID();
	mrFData->SecondID=otherID;
	callRunTimeFunction(mrFData, RFUNCTION_GENERATEEVENT, 1, 0);
}
// ============================================================================
//
// CONDITION ROUTINES
// 
// ============================================================================

float VortexFloatParam(LPRDATA rdPtr)
{
	float p1;
	long tmp=CNC_GetFloatParameter(rdPtr);
	p1=*reinterpret_cast<float*>(&tmp);
	return p1;
}

void GenerateError(LPRDATA rdPtr,char*pError)
{
	rdPtr->Error=pError;
	callRunTimeFunction(rdPtr, RFUNCTION_GENERATEEVENT, 3, 0);
}
/* startfunc_c: conOnObj */
long WINAPI DLLExport conOnObj(LPRDATA rdPtr, long param1, long param2)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetParameter(rdPtr));	// Object ID

	return FALSE;
}
/* endfunc_c: conOnObj */

/* startfunc_c: conOnCollision */
long WINAPI DLLExport conOnCollision(LPRDATA rdPtr, long param1, long param2)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetParameter(rdPtr));	// First Object ID
	char* p2 = reinterpret_cast<char*>(CNC_GetParameter(rdPtr));	// Second Object ID
	if((std::string(p1)==rdPtr->FirstID&&std::string(p2)==rdPtr->SecondID)||(std::string(p2)==rdPtr->FirstID&&std::string(p1)==rdPtr->SecondID))
	{
		return TRUE;
	}
	return FALSE;
}
/* endfunc_c: conOnCollision */

/* startfunc_c: conObjEnabled */
long WINAPI DLLExport conObjEnabled(LPRDATA rdPtr, long param1, long param2)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetParameter(rdPtr));	// Object ID

	return FALSE;
}
/* endfunc_c: conObjEnabled */

/* startfunc_c: conOnError */
long WINAPI DLLExport conOnError(LPRDATA rdPtr, long param1, long param2)
{
	return TRUE;
}
/* endfunc_c: conOnError */

// ============================================================================
//
// ACTIONS ROUTINES
// 
// ============================================================================



/* startfunc_a: actLoadWorld */
short WINAPI DLLExport actLoadWorld(LPRDATA rdPtr, long param1, long param2)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetParameter(rdPtr));	// Filename

	return 0;
}
/* endfunc_a: actLoadWorld */

/* startfunc_a: actAddObject */
short WINAPI DLLExport actAddObject(LPRDATA rdPtr, long param1, long param2)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));	// Object ID
	float p2 = VortexFloatParam(rdPtr); //X Position
	float p3 = VortexFloatParam(rdPtr);	// Y Position
	float p4 = VortexFloatParam(rdPtr);	// X Velocity
	float p5 = VortexFloatParam(rdPtr);	// Y Velocity
	long p6 = CNC_GetIntParameter(rdPtr);		// Use AutoDisable (Use 0 for Off and 1 for On)
	mrFData=rdPtr;
	FusionObj *mFusObj=new FusionObj(rdPtr->mWorld->GetWorld(),vec2(p2,p3));
	mFusObj->SetID((string)p1);
	mFusObj->GetFlatlandObject()->SetMass(40);
	mFusObj->GetFlatlandObject()->Property().friction=dInfinity;
	mFusObj->GetFlatlandObject()->Property().callback=mFusObj->fustaticCallback;
	mFusObj->Insert(rdPtr->mWorld->GetSpace());
	rdPtr->mWorld->GetSpace().SortObjLst();
	return 0;
}
/* endfunc_a: actAddObject */

/* startfunc_a: actSetGlobalERP */
short WINAPI DLLExport actSetGlobalERP(LPRDATA rdPtr, long param1, long param2)
{
	float p1=VortexFloatParam(rdPtr);// Error Reduction Parameter
	rdPtr->mWorld->GetWorld().SetERP(p1);
	return 0;
}
/* endfunc_a: actSetGlobalERP */

/* startfunc_a: actSetGlobalCFM */
short WINAPI DLLExport actSetGlobalCFM(LPRDATA rdPtr, long param1, long param2)
{
	float p1=VortexFloatParam(rdPtr);	// Constant Force Mixing
	rdPtr->mWorld->GetWorld().SetCFM(p1);
	return 0;
}
/* endfunc_a: actSetGlobalCFM */

/* startfunc_a: actSetGravity */
short WINAPI DLLExport actSetGravity(LPRDATA rdPtr, long param1, long param2)
{
	float p1=VortexFloatParam(rdPtr);	// X Gravity Velocity
	float p2=VortexFloatParam(rdPtr);	// Y Gravity Velocity
	rdPtr->mWorld->GetWorld().SetGravity(vec2(p1,p2));
	return 0;
}
/* endfunc_a: actSetGravity */

/* startfunc_a: actSetBorderFlag */
short WINAPI DLLExport actSetBorderFlag(LPRDATA rdPtr, long param1, long param2)
{
	long p1 = CNC_GetIntParameter(rdPtr);			// Border Flag (Use 0 for OFF and 1 for ON)

	return 0;
}
/* endfunc_a: actSetBorderFlag */

/* startfunc_a: actSetAutoUpdateFlag */
short WINAPI DLLExport actSetAutoUpdateFlag(LPRDATA rdPtr, long param1, long param2)
{
	long p1 = CNC_GetIntParameter(rdPtr);			// Auto Update Flag (Use 0 for OFF and 1 for ON) 

	return 0;
}
/* endfunc_a: actSetAutoUpdateFlag */

/* startfunc_a: actUpdateWorld */
short WINAPI DLLExport actUpdateWorld(LPRDATA rdPtr, long param1, long param2)
{
	float p1=VortexFloatParam(rdPtr);	// Step Size
	rdPtr->mWorld->Step(p1);
	rdPtr->mWorld->Draw();
	return 0;
}
/* endfunc_a: actUpdateWorld */

/* startfunc_a: actAddBoxToObj */
short WINAPI DLLExport actAddBoxToObj(LPRDATA rdPtr, long param1, long param2)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));	// Geometry ID
	char* p2 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));	// Object ID
	float p3 = VortexFloatParam(rdPtr);	// X Position
	float p4 = VortexFloatParam(rdPtr);	// Y Position
	float p5 = VortexFloatParam(rdPtr);	// Width
	float p6 = VortexFloatParam(rdPtr);// Height
	Object*tObj=rdPtr->mWorld->GetSpace().FindObj((string)p2);
	if(tObj!=NULL)
		tObj->Add(new Flatland::Block(vec2(p3,p4),p5,p6),(string)p1);
	else
		GenerateError(rdPtr,"Can't add block primitive, object not found!");
	return 0;
}
/* endfunc_a: actAddBoxToObj */

/* startfunc_a: actAddCircleToObj */
short WINAPI DLLExport actAddCircleToObj(LPRDATA rdPtr, long param1, long param2)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));	// Geometry ID
	char* p2 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));	// Object ID
	float p3 = VortexFloatParam(rdPtr);	// X Position
	float p4 = VortexFloatParam(rdPtr);	// Y Position
	float p5 = VortexFloatParam(rdPtr);	// Radius
	Object*tObj=rdPtr->mWorld->GetSpace().FindObj((string)p2);
	if(tObj!=NULL)
		tObj->Add(new Flatland::Circle(vec2(p3,p4),p5),(string)p1);
	else
		GenerateError(rdPtr,"Can't add circle primitive, object not found!");
	return 0;
}
/* endfunc_a: actAddCircleToObj */

/* startfunc_a: actSetObjCenter */
short WINAPI DLLExport actSetObjCenter(LPRDATA rdPtr, long param1, long param2)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));	// Object ID
	float p2 = VortexFloatParam(rdPtr);	// Relative X
	float p3 = VortexFloatParam(rdPtr);				// Relative Y
	Object*tObj=rdPtr->mWorld->GetSpace().FindObj((string)p1);
	if(tObj!=NULL)
	{
		tObj->SetCenter(vec2(p2,p3));
	}
	else
		GenerateError(rdPtr,"Can't set object center, object not found!");
	return 0;
}
/* endfunc_a: actSetObjCenter */

/* startfunc_a: actRemovePrimitive */
short WINAPI DLLExport actRemovePrimitive(LPRDATA rdPtr, long param1, long param2)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));	// Geometry ID
	char* p2 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));	// Object ID
	Object*tObj=rdPtr->mWorld->GetSpace().FindObj((string)p2);
	if(tObj!=NULL)
		tObj->Remove(p1);
	else
		GenerateError(rdPtr,"Can't remove geometry, object not found!");
	return 0;
}
/* endfunc_a: actRemovePrimitive */

/* startfunc_a: actSetActive */
short WINAPI DLLExport actSetActive(LPRDATA rdPtr, long param1, long param2)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));	// Object ID
	LPRO obj2 = reinterpret_cast<LPRO>(CNC_GetParameter(rdPtr));	// Pick an active
	Object*tObj=rdPtr->mWorld->GetSpace().FindObj((string)p1);
	if(tObj!=NULL)
		tObj->SetPrivateData((void*)obj2);
	else
		GenerateError(rdPtr,"Can't set active, object not found!");
	return 0;
}
/* endfunc_a: actSetActive */

/* startfunc_a: actSetObjX */
short WINAPI DLLExport actSetObjX(LPRDATA rdPtr, long param1, long param2)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));	// Object ID
	float p2=VortexFloatParam(rdPtr);	// X Position
	Object*tObj=rdPtr->mWorld->GetSpace().FindObj((string)p1);
	if(tObj!=NULL)
	{
		float ypos=tObj->GetFlatlandObject()->GetGeometry().Center().y;
		tObj->SetPosition(vec2(p2,ypos));
	}
	else
		GenerateError(rdPtr,"Can't change X position, object not found!");
	return 0;
}
/* endfunc_a: actSetObjX */

/* startfunc_a: actSetObjY */
short WINAPI DLLExport actSetObjY(LPRDATA rdPtr, long param1, long param2)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));	// Object ID
	float p2=VortexFloatParam(rdPtr);	// Y Position
	Object*tObj=rdPtr->mWorld->GetSpace().FindObj((string)p1);
	if(tObj!=NULL)
	{
		float xpos=tObj->GetFlatlandObject()->GetGeometry().Center().x;
		tObj->SetPosition(vec2(xpos,p2));
	}
	else
		GenerateError(rdPtr,"Can't change Y position, object not found!");
	return 0;
}
/* endfunc_a: actSetObjY */

/* startfunc_a: actSetObjAngle */
short WINAPI DLLExport actSetObjAngle(LPRDATA rdPtr, long param1, long param2)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));	// Object ID
	float p2=VortexFloatParam(rdPtr);	// Angle
	Object*tObj=rdPtr->mWorld->GetSpace().FindObj((string)p1);
	if(tObj!=NULL)
		tObj->GetFlatlandObject()->Rotate(p2);
	else
		GenerateError(rdPtr,"Can't change angle, object not found!");
	return 0;
}
/* endfunc_a: actSetObjAngle */

/* startfunc_a: actSetObjAngVel */
short WINAPI DLLExport actSetObjAngVel(LPRDATA rdPtr, long param1, long param2)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));	// Object ID
	float p2 = VortexFloatParam(rdPtr);	// X Angular Velocity
	float p3 = VortexFloatParam(rdPtr);	// Y Angular Velocity
	
	return 0;
}
/* endfunc_a: actSetObjAngVel */

/* startfunc_a: actSetObjLinVel */
short WINAPI DLLExport actSetObjLinVel(LPRDATA rdPtr, long param1, long param2)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));	// Object ID
	float p2 = VortexFloatParam(rdPtr);	// X Linear Velocity
	float p3 = VortexFloatParam(rdPtr);	// Y Linear Velocity

	return 0;
}
/* endfunc_a: actSetObjLinVel */

/* startfunc_a: actSetObjMass */
short WINAPI DLLExport actSetObjMass(LPRDATA rdPtr, long param1, long param2)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));	// Object ID
	float p2=VortexFloatParam(rdPtr);	// Mass
	Object*tObj=rdPtr->mWorld->GetSpace().FindObj((string)p1);
	if(tObj!=NULL)
		tObj->GetFlatlandObject()->SetMass(p2);
	else
		GenerateError(rdPtr,"Can't change mass, object not found!");
	return 0;
}
/* endfunc_a: actSetObjMass */

/* startfunc_a: actSetObjGravityMode */
short WINAPI DLLExport actSetObjGravityMode(LPRDATA rdPtr, long param1, long param2)
{
	long p1 = CNC_GetIntParameter(rdPtr);			// Gravity Mode (Use 0 for OFF and 1 for ON)

	return 0;
}
/* endfunc_a: actSetObjGravityMode */

/* startfunc_a: actSetObjBounceCoeff */
short WINAPI DLLExport actSetObjBounceCoeff(LPRDATA rdPtr, long param1, long param2)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));	// Object ID
	float p2=VortexFloatParam(rdPtr);	// Bounce Coefficent
	Object*tObj=rdPtr->mWorld->GetSpace().FindObj((string)p1);
	if(tObj!=NULL)
		tObj->GetFlatlandObject()->Property().bounceFactor=p2;
	else
		GenerateError(rdPtr,"Can't change bounce coeff, object not found!");
	return 0;
}
/* endfunc_a: actSetObjBounceCoeff */

/* startfunc_a: actSetObjFrictionCoeff */
short WINAPI DLLExport actSetObjFrictionCoeff(LPRDATA rdPtr, long param1, long param2)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));	// Object ID
	float p2=VortexFloatParam(rdPtr);	// Friction Coefficent
	Object*tObj=rdPtr->mWorld->GetSpace().FindObj((string)p1);
	if(tObj!=NULL)
	{
		if(p2!=-1)
			tObj->GetFlatlandObject()->Property().friction=p2;
		else
			tObj->GetFlatlandObject()->Property().friction=dInfinity;
	}
	else
		GenerateError(rdPtr,"Can't change friction, object not found");

	return 0;
}
/* endfunc_a: actSetObjFrictionCoeff */

/* startfunc_a: actSetObjSoftCoeff */
short WINAPI DLLExport actSetObjSoftCoeff(LPRDATA rdPtr, long param1, long param2)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));	// Object ID
	float p2=VortexFloatParam(rdPtr);	// Softness Coefficent
	Object*tObj=rdPtr->mWorld->GetSpace().FindObj((string)p1);
	if(tObj!=NULL)
		tObj->GetFlatlandObject()->Property().bounceVelocity=p2;
	return 0;
}
/* endfunc_a: actSetObjSoftCoeff */

/* startfunc_a: actSetObjAutoDisableFlag */
short WINAPI DLLExport actSetObjAutoDisableFlag(LPRDATA rdPtr, long param1, long param2)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));	// Object ID
	long p2 = CNC_GetIntParameter(rdPtr);			// Auto Disable Flag (Use 0 for OFF and 1 for ON)

	return 0;
}
/* endfunc_a: actSetObjAutoDisableFlag */

/* startfunc_a: actSetObjStaticFlag */
short WINAPI DLLExport actSetObjStaticFlag(LPRDATA rdPtr, long param1, long param2)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));	// Object ID
	long p2 = CNC_GetIntParameter(rdPtr);			// Static Flag (Use 0 for dynamic objects, and 1 for static objects)
	return 0;
}
/* endfunc_a: actSetObjStaticFlag */

/* startfunc_a: actSetObjEnabledFlag */
short WINAPI DLLExport actSetObjEnabledFlag(LPRDATA rdPtr, long param1, long param2)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));	// Object ID
	long p2 = CNC_GetIntParameter(rdPtr);			// Enabled Flag (Use 0 for disabled, and 1 for enabled)

	return 0;
}
/* endfunc_a: actSetObjEnabledFlag */

/* startfunc_a: actAddObjForce */
short WINAPI DLLExport actAddObjForce(LPRDATA rdPtr, long param1, long param2)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));	// Object ID
	float p2 = VortexFloatParam(rdPtr);	// Absolute X
	float p3 = VortexFloatParam(rdPtr);	// Absolute Y
	
	return 0;
}
/* endfunc_a: actAddObjForce */

/* startfunc_a: actAddObjRelForce */
short WINAPI DLLExport actAddObjRelForce(LPRDATA rdPtr, long param1, long param2)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));	// Object ID
	float p2 = VortexFloatParam(rdPtr);	// Relative X
	float p3 = VortexFloatParam(rdPtr);	// Relative Y

	return 0;
}
/* endfunc_a: actAddObjRelForce */

/* startfunc_a: actAddObjTorque */
short WINAPI DLLExport actAddObjTorque(LPRDATA rdPtr, long param1, long param2)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));	// Object ID
	float p2 = VortexFloatParam(rdPtr);	// Absolute X
	float p3 = VortexFloatParam(rdPtr);	// Absolute Y

	return 0;
}
/* endfunc_a: actAddObjTorque */

/* startfunc_a: actAddObjRelTorque */
short WINAPI DLLExport actAddObjRelTorque(LPRDATA rdPtr, long param1, long param2)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));	// Object ID
	float p2 =VortexFloatParam(rdPtr);	// Relative X
	float p3 =VortexFloatParam(rdPtr);	// Relative Y

	return 0;
}
/* endfunc_a: actAddObjRelTorque */

/* startfunc_a: actAddSliderJoint */
short WINAPI DLLExport actAddSliderJoint(LPRDATA rdPtr, long param1, long param2)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));	// Joint ID
	char* p2 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));	// First Object ID
	long p3 = CNC_GetIntParameter(rdPtr);				// Second Object ID

	return 0;
}
/* endfunc_a: actAddSliderJoint */

/* startfunc_a: actAddHingeJoint */
short WINAPI DLLExport actAddHingeJoint(LPRDATA rdPtr, long param1, long param2)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));	// Joint ID
	char* p2 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));	// First Object ID
	char* p3 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));	// Second Object ID
	Object*tObj1=rdPtr->mWorld->GetSpace().FindObj((string)p2);
	Object*tObj2=rdPtr->mWorld->GetSpace().FindObj((string)p3);
	if(tObj1!=NULL&&tObj2!=NULL)
	{
		rdPtr->mWorld->GetWorld().Anchor(*tObj1->GetFlatlandObject(),*tObj2->GetFlatlandObject(),tObj1->GetFlatlandObject()->GetGeometry().Center(),100,0.01f);
		//need to keep track of Joint ID
	}
	return 0;
}
/* endfunc_a: actAddHingeJoint */

/* startfunc_a: actSetJointRigidity */
short WINAPI DLLExport actSetJointRigidity(LPRDATA rdPtr, long param1, long param2)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));	// Joint ID
	float p2 = VortexFloatParam(rdPtr);		// Spring Constant
	long p3 = CNC_GetIntParameter(rdPtr);				// Damping Constant

	return 0;
}
/* endfunc_a: actSetJointRigidity */

/* startfunc_a: actRemoveJoint */
short WINAPI DLLExport actRemoveJoint(LPRDATA rdPtr, long param1, long param2)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));	// Joint ID
	char* p2 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));	// First Object ID
	char* p3 = reinterpret_cast<char*>(CNC_GetStringParameter(rdPtr));	// Second Object ID

	return 0;
}
/* endfunc_a: actRemoveJoint */

/* startfunc_a: actClearError */
short WINAPI DLLExport actClearError(LPRDATA rdPtr, long param1, long param2)
{
	rdPtr->Error="";
	return 0;
}
/* endfunc_a: actClearError */

// ============================================================================
//
// EXPRESSIONS ROUTINES
// 
// ============================================================================



/* startfunc_e: expGetID */
long WINAPI DLLExport expGetID(LPRDATA rdPtr, long param1)
{
	rdPtr->rHo.hoFlags |= HOF_STRING;
	char*	retStr = "";

	// Return string
	return reinterpret_cast<long>(retStr);
}
/* endfunc_e: expGetID */

/* startfunc_e: expGetERP */
long WINAPI DLLExport expGetERP(LPRDATA rdPtr, long param1)
{
	rdPtr->rHo.hoFlags |= HOF_FLOAT;
	float	retVal = 0;

	// Return float
	long	retHolder = 0;
	memcpy(&retHolder,&retVal,sizeof(long));
	return retHolder;
}
/* endfunc_e: expGetERP */

/* startfunc_e: expGetCFM */
long WINAPI DLLExport expGetCFM(LPRDATA rdPtr, long param1)
{
	rdPtr->rHo.hoFlags |= HOF_FLOAT;
	float	retVal = 0;

	// Return float
	long	retHolder = 0;
	memcpy(&retHolder,&retVal,sizeof(long));
	return retHolder;
}
/* endfunc_e: expGetCFM */

/* startfunc_e: expGetGravX */
long WINAPI DLLExport expGetGravX(LPRDATA rdPtr, long param1)
{
	rdPtr->rHo.hoFlags |= HOF_FLOAT;
	float	retVal = 0;
	dVector3 grav;
	dWorldGetGravity(rdPtr->mWorld->GetWorld().world,grav);
	// Return float
	retVal=grav[0];
	long	retHolder = 0;
	memcpy(&retHolder,&retVal,sizeof(long));
	return retHolder;
}
/* endfunc_e: expGetGravX */

/* startfunc_e: expGetGravY */
long WINAPI DLLExport expGetGravY(LPRDATA rdPtr, long param1)
{
	rdPtr->rHo.hoFlags |= HOF_FLOAT;
	float	retVal = 0;
	dVector3 grav;
	dWorldGetGravity(rdPtr->mWorld->GetWorld().world,grav);
	// Return float
	retVal=grav[1];
	// Return float
	long	retHolder = 0;
	memcpy(&retHolder,&retVal,sizeof(long));
	return retHolder;
}
/* endfunc_e: expGetGravY */

/* startfunc_e: expGetBorderState */
long WINAPI DLLExport expGetBorderState(LPRDATA rdPtr, long param1)
{


	return 0;
}
/* endfunc_e: expGetBorderState */

/* startfunc_e: expGetAutoUpState */
long WINAPI DLLExport expGetAutoUpState(LPRDATA rdPtr, long param1)
{


	return 0;
}
/* endfunc_e: expGetAutoUpState */

/* startfunc_e: expGetObjXCenter */
long WINAPI DLLExport expGetObjXCenter(LPRDATA rdPtr, long param1)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_STRING));	// Object ID
	rdPtr->rHo.hoFlags |= HOF_FLOAT;
	float	retVal = 0;

	// Return float
	long	retHolder = 0;
	memcpy(&retHolder,&retVal,sizeof(long));
	return retHolder;
}
/* endfunc_e: expGetObjXCenter */

/* startfunc_e: expGetObjYCenter */
long WINAPI DLLExport expGetObjYCenter(LPRDATA rdPtr, long param1)
{
	rdPtr->rHo.hoFlags |= HOF_FLOAT;
	float	retVal = 0;

	// Return float
	long	retHolder = 0;
	memcpy(&retHolder,&retVal,sizeof(long));
	return retHolder;
}
/* endfunc_e: expGetObjYCenter */

/* startfunc_e: expGetObjXPos */
long WINAPI DLLExport expGetObjXPos(LPRDATA rdPtr, long param1)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_STRING));	// Object ID
	rdPtr->rHo.hoFlags |= HOF_FLOAT;
	float	retVal = 0;
	Object*tObj=rdPtr->mWorld->GetSpace().FindObj((string)p1);
	if(tObj!=NULL)
		retVal=tObj->GetFlatlandObject()->GetGeometry().Center().x;
	else
	{
		retVal=0.0f;
		rdPtr->Error="Object not found with matching ID!";
		callRunTimeFunction(mrFData, RFUNCTION_GENERATEEVENT, 3, 0);
	}
	// Return float
	long	retHolder = 0;
	memcpy(&retHolder,&retVal,sizeof(long));
	return retHolder;
}
/* endfunc_e: expGetObjXPos */

/* startfunc_e: expGetObjYPos */
long WINAPI DLLExport expGetObjYPos(LPRDATA rdPtr, long param1)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_STRING));	// Object ID
	rdPtr->rHo.hoFlags |= HOF_FLOAT;
	float	retVal = 0;
	Object*tObj=rdPtr->mWorld->GetSpace().FindObj((string)p1);
	if(tObj!=NULL)
		retVal=tObj->GetFlatlandObject()->GetGeometry().Center().y;
	else
	{
		retVal=0.0f;
		rdPtr->Error="Object not found with matching ID!";
		callRunTimeFunction(mrFData, RFUNCTION_GENERATEEVENT, 3, 0);
	}
	// Return float
	long	retHolder = 0;
	memcpy(&retHolder,&retVal,sizeof(long));
	return retHolder;
}
/* endfunc_e: expGetObjYPos */

/* startfunc_e: expGetObjAng */
long WINAPI DLLExport expGetObjAng(LPRDATA rdPtr, long param1)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_STRING));	// Object ID
	rdPtr->rHo.hoFlags |= HOF_FLOAT;
	const dReal epsilon=0.0000001;
	float mAng=0;
	Object*tObj=rdPtr->mWorld->GetSpace().FindObj((string)p1);
	if(tObj!=NULL)
	{
		if(	tObj->GetFlatlandObject()->GetBody()->R[2] < 1-epsilon && 	tObj->GetFlatlandObject()->GetBody()->R[2] > -1+epsilon)
		{
			dReal c=cos(-asin(tObj->GetFlatlandObject()->GetBody()->R[2]));
			mAng= atan2(tObj->GetFlatlandObject()->GetBody()->R[1]/c,tObj->GetFlatlandObject()->GetBody()->R[0]/c);
			mAng=mAng*(180/3.14159);
		} 
		else 
		{       
			mAng=0;   
		} 
	}
	else
	{
		rdPtr->Error="Object not found with matching ID!";
		callRunTimeFunction(mrFData, RFUNCTION_GENERATEEVENT, 3, 0);
	}
	// Return float
	long	retHolder = 0;
	memcpy(&retHolder,&mAng,sizeof(long));
	return retHolder;
}
/* endfunc_e: expGetObjAng */

/* startfunc_e: expGetObjAngVelX */
long WINAPI DLLExport expGetObjAngVelX(LPRDATA rdPtr, long param1)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_STRING));	// Object ID
	rdPtr->rHo.hoFlags |= HOF_FLOAT;
	float	retVal = 0;

	// Return float
	long	retHolder = 0;
	memcpy(&retHolder,&retVal,sizeof(long));
	return retHolder;
}
/* endfunc_e: expGetObjAngVelX */

/* startfunc_e: expGetObjAngVelY */
long WINAPI DLLExport expGetObjAngVelY(LPRDATA rdPtr, long param1)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_STRING));	// Object ID
	rdPtr->rHo.hoFlags |= HOF_FLOAT;
	float	retVal = 0;

	// Return float
	long	retHolder = 0;
	memcpy(&retHolder,&retVal,sizeof(long));
	return retHolder;
}
/* endfunc_e: expGetObjAngVelY */

/* startfunc_e: expGetObjLinVelX */
long WINAPI DLLExport expGetObjLinVelX(LPRDATA rdPtr, long param1)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_STRING));	// Object ID
	rdPtr->rHo.hoFlags |= HOF_FLOAT;
	float	retVal = 0;

	// Return float
	long	retHolder = 0;
	memcpy(&retHolder,&retVal,sizeof(long));
	return retHolder;
}
/* endfunc_e: expGetObjLinVelX */

/* startfunc_e: expGetObjLinVelY */
long WINAPI DLLExport expGetObjLinVelY(LPRDATA rdPtr, long param1)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_STRING));	// Object ID
	rdPtr->rHo.hoFlags |= HOF_FLOAT;
	float	retVal = 0;

	// Return float
	long	retHolder = 0;
	memcpy(&retHolder,&retVal,sizeof(long));
	return retHolder;
}
/* endfunc_e: expGetObjLinVelY */

/* startfunc_e: expGetObjMass */
long WINAPI DLLExport expGetObjMass(LPRDATA rdPtr, long param1)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_STRING));	// Object ID
	rdPtr->rHo.hoFlags |= HOF_FLOAT;
	float	retVal = 0;
	Object*tObj=rdPtr->mWorld->GetSpace().FindObj((string)p1);
	if(tObj!=NULL)
		retVal=tObj->GetFlatlandObject()->GetBody()->mass.mass/(100*100);
	else
		GenerateError(rdPtr,"Can't get mass, object not found");
	// Return float
	long	retHolder = 0;
	memcpy(&retHolder,&retVal,sizeof(long));
	return retHolder;
}
/* endfunc_e: expGetObjMass */

/* startfunc_e: expGetObjGravMode */
long WINAPI DLLExport expGetObjGravMode(LPRDATA rdPtr, long param1)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_STRING));	// Object ID


	return 0;
}
/* endfunc_e: expGetObjGravMode */

/* startfunc_e: expGetObjBounceCoeff */
long WINAPI DLLExport expGetObjBounceCoeff(LPRDATA rdPtr, long param1)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_STRING));	// Object ID
	rdPtr->rHo.hoFlags |= HOF_FLOAT;
	float	retVal = 0;
	Object*tObj=rdPtr->mWorld->GetSpace().FindObj((string)p1);
	if(tObj!=NULL)
		retVal=tObj->GetFlatlandObject()->Property().bounceFactor;
	else
		GenerateError(rdPtr,"Can't get bounce coeff, object not found!");
	// Return float
	long	retHolder = 0;
	memcpy(&retHolder,&retVal,sizeof(long));
	return retHolder;
}
/* endfunc_e: expGetObjBounceCoeff */

/* startfunc_e: expGetObjFricCoeff */
long WINAPI DLLExport expGetObjFricCoeff(LPRDATA rdPtr, long param1)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_STRING));	// Object ID
	rdPtr->rHo.hoFlags |= HOF_FLOAT;
	float	retVal = 0;
	Object*tObj=rdPtr->mWorld->GetSpace().FindObj((string)p1);
	if(tObj!=NULL)
		retVal=tObj->GetFlatlandObject()->Property().friction;
	else
		GenerateError(rdPtr,"Can't get friction coeff, object not found!");
	// Return float
	long	retHolder = 0;
	memcpy(&retHolder,&retVal,sizeof(long));
	return retHolder;
}
/* endfunc_e: expGetObjFricCoeff */

/* startfunc_e: expGetObjSoftCoeff */
long WINAPI DLLExport expGetObjSoftCoeff(LPRDATA rdPtr, long param1)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_STRING));	// Object ID
	rdPtr->rHo.hoFlags |= HOF_FLOAT;
	float	retVal = 0;
	Object*tObj=rdPtr->mWorld->GetSpace().FindObj((string)p1);
	if(tObj!=NULL)
		retVal=tObj->GetFlatlandObject()->Property().bounceVelocity;
	else
		GenerateError(rdPtr,"Can't get soft coeff, object not found!");
	// Return float
	long	retHolder = 0;
	memcpy(&retHolder,&retVal,sizeof(long));
	return retHolder;
}
/* endfunc_e: expGetObjSoftCoeff */

/* startfunc_e: expGetObjAutoDisableState */
long WINAPI DLLExport expGetObjAutoDisableState(LPRDATA rdPtr, long param1)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_STRING));	// Object ID


	return 0;
}
/* endfunc_e: expGetObjAutoDisableState */

/* startfunc_e: expGetObjStaticState */
long WINAPI DLLExport expGetObjStaticState(LPRDATA rdPtr, long param1)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_STRING));	// Object ID


	return 0;
}
/* endfunc_e: expGetObjStaticState */

/* startfunc_e: expGetObjEnableState */
long WINAPI DLLExport expGetObjEnableState(LPRDATA rdPtr, long param1)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_STRING));	// Object ID


	return 0;
}
/* endfunc_e: expGetObjEnableState */

/* startfunc_e: expGetJointCount */
long WINAPI DLLExport expGetJointCount(LPRDATA rdPtr, long param1)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_STRING));	// Object ID


	return 0;
}
/* endfunc_e: expGetJointCount */

/* startfunc_e: expGetJointSpringConstant */
long WINAPI DLLExport expGetJointSpringConstant(LPRDATA rdPtr, long param1)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_STRING));	// Object ID
	rdPtr->rHo.hoFlags |= HOF_FLOAT;
	float	retVal = 0;

	// Return float
	long	retHolder = 0;
	memcpy(&retHolder,&retVal,sizeof(long));
	return retHolder;
}
/* endfunc_e: expGetJointSpringConstant */

/* startfunc_e: expGetJointDampingConstant */
long WINAPI DLLExport expGetJointDampingConstant(LPRDATA rdPtr, long param1)
{
	char* p1 = reinterpret_cast<char*>(CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_STRING));	// Object ID
	rdPtr->rHo.hoFlags |= HOF_FLOAT;
	float	retVal = 0;

	// Return float
	long	retHolder = 0;
	memcpy(&retHolder,&retVal,sizeof(long));
	return retHolder;
}
/* endfunc_e: expGetJointDampingConstant */

/* startfunc_e: expGetErrorMessage */
long WINAPI DLLExport expGetErrorMessage(LPRDATA rdPtr, long param1)
{
	rdPtr->rHo.hoFlags |= HOF_STRING;
	char*	retStr = "";
	retStr=(char*)rdPtr->Error.c_str();
	// Return string
	return reinterpret_cast<long>(retStr);
}
/* endfunc_e: expGetErrorMessage */

// Quick memo: content of the eventInformations arrays
// ---------------------------------------------------
// Menu ID
// String ID
// Code
// Flags
// Number_of_parameters
// Parameter_type [Number_of_parameters]
// Parameter_TitleString [Number_of_parameters]

// Definitions of parameters for each condition
short conditionsInfos[]=
{
	IDMN_CONONOBJ,	IDS_CONONOBJ,	CND_CONONOBJ,	0,	1,	PARAM_EXPSTRING,	IDS_CONONOBJ_P0,
	IDMN_CONONCOLLISION,	IDS_CONONCOLLISION,	CND_CONONCOLLISION,	0,	2,	PARAM_EXPSTRING,	PARAM_EXPSTRING,	IDS_CONONCOLLISION_P0,	IDS_CONONCOLLISION_P1,
	IDMN_CONOBJENABLED,	IDS_CONOBJENABLED,	CND_CONOBJENABLED,	EVFLAGS_ALWAYS | EVFLAGS_NOTABLE,	1,	PARAM_EXPSTRING,	IDS_CONOBJENABLED_P0,
	IDMN_CONONERROR,	IDS_CONONERROR,	CND_CONONERROR,	0,	0,
};

// Definitions of parameters for each action
short actionsInfos[]=
{
	IDMN_ACTLOADWORLD,	IDS_ACTLOADWORLD,	ACT_ACTLOADWORLD,	0,	1,	PARAM_EXPSTRING,	IDS_ACTLOADWORLD_P0,
	IDMN_ACTADDOBJECT,	IDS_ACTADDOBJECT,	ACT_ACTADDOBJECT,	0,	6,	PARAM_EXPSTRING,	PARAM_EXPRESSION,	PARAM_EXPRESSION,	PARAM_EXPRESSION,	PARAM_EXPRESSION,	PARAM_EXPRESSION,	IDS_ACTADDOBJECT_P0,	IDS_ACTADDOBJECT_P1,	IDS_ACTADDOBJECT_P2,	IDS_ACTADDOBJECT_P3,	IDS_ACTADDOBJECT_P4,	IDS_ACTADDOBJECT_P5,
	IDMN_ACTSETGLOBALERP,	IDS_ACTSETGLOBALERP,	ACT_ACTSETGLOBALERP,	0,	1,	PARAM_EXPRESSION,	IDS_ACTSETGLOBALERP_P0,
	IDMN_ACTSETGLOBALCFM,	IDS_ACTSETGLOBALCFM,	ACT_ACTSETGLOBALCFM,	0,	1,	PARAM_EXPRESSION,	IDS_ACTSETGLOBALCFM_P0,
	IDMN_ACTSETGRAVITY,	IDS_ACTSETGRAVITY,	ACT_ACTSETGRAVITY,	0,	2,	PARAM_EXPRESSION,	PARAM_EXPRESSION,	IDS_ACTSETGRAVITY_P0,	IDS_ACTSETGRAVITY_P1,
	IDMN_ACTSETBORDERFLAG,	IDS_ACTSETBORDERFLAG,	ACT_ACTSETBORDERFLAG,	0,	1,	PARAM_EXPRESSION,	IDS_ACTSETBORDERFLAG_P0,
	IDMN_ACTSETAUTOUPDATEFLAG,	IDS_ACTSETAUTOUPDATEFLAG,	ACT_ACTSETAUTOUPDATEFLAG,	0,	1,	PARAM_EXPRESSION,	IDS_ACTSETAUTOUPDATEFLAG_P0,
	IDMN_ACTUPDATEWORLD,	IDS_ACTUPDATEWORLD,	ACT_ACTUPDATEWORLD,	0,	1,	PARAM_EXPRESSION,	IDS_ACTUPDATEWORLD_P0,
	IDMN_ACTADDBOXTOOBJ,	IDS_ACTADDBOXTOOBJ,	ACT_ACTADDBOXTOOBJ,	0,	6,	PARAM_EXPSTRING,	PARAM_EXPSTRING,	PARAM_EXPRESSION,	PARAM_EXPRESSION,	PARAM_EXPRESSION,	PARAM_EXPRESSION,	IDS_ACTADDBOXTOOBJ_P0,	IDS_ACTADDBOXTOOBJ_P1,	IDS_ACTADDBOXTOOBJ_P2,	IDS_ACTADDBOXTOOBJ_P3,	IDS_ACTADDBOXTOOBJ_P4,	IDS_ACTADDBOXTOOBJ_P5,
	IDMN_ACTADDCIRCLETOOBJ,	IDS_ACTADDCIRCLETOOBJ,	ACT_ACTADDCIRCLETOOBJ,	0,	5,	PARAM_EXPSTRING,	PARAM_EXPSTRING,	PARAM_EXPRESSION,	PARAM_EXPRESSION,	PARAM_EXPRESSION,	IDS_ACTADDCIRCLETOOBJ_P0,	IDS_ACTADDCIRCLETOOBJ_P1,	IDS_ACTADDCIRCLETOOBJ_P2,	IDS_ACTADDCIRCLETOOBJ_P3,	IDS_ACTADDCIRCLETOOBJ_P4,
	IDMN_ACTSETOBJCENTER,	IDS_ACTSETOBJCENTER,	ACT_ACTSETOBJCENTER,	0,	3,	PARAM_EXPSTRING,	PARAM_EXPRESSION,	PARAM_EXPRESSION,	IDS_ACTSETOBJCENTER_P0,	IDS_ACTSETOBJCENTER_P1,	IDS_ACTSETOBJCENTER_P2,
	IDMN_ACTREMOVEPRIMITIVE,	IDS_ACTREMOVEPRIMITIVE,	ACT_ACTREMOVEPRIMITIVE,	0,	2,	PARAM_EXPSTRING,	PARAM_EXPSTRING,	IDS_ACTREMOVEPRIMITIVE_P0,	IDS_ACTREMOVEPRIMITIVE_P1,
	IDMN_ACTSETACTIVE,	IDS_ACTSETACTIVE,	ACT_ACTSETACTIVE,	0,	2,	PARAM_EXPSTRING,	PARAM_OBJECT,	IDS_ACTSETACTIVE_P0,	IDS_ACTSETACTIVE_P1,
	IDMN_ACTSETOBJX,	IDS_ACTSETOBJX,	ACT_ACTSETOBJX,	0,	2,	PARAM_EXPSTRING,	PARAM_EXPRESSION,	IDS_ACTSETOBJX_P0,	IDS_ACTSETOBJX_P1,
	IDMN_ACTSETOBJY,	IDS_ACTSETOBJY,	ACT_ACTSETOBJY,	0,	2,	PARAM_EXPSTRING,	PARAM_EXPRESSION,	IDS_ACTSETOBJY_P0,	IDS_ACTSETOBJY_P1,
	IDMN_ACTSETOBJANGLE,	IDS_ACTSETOBJANGLE,	ACT_ACTSETOBJANGLE,	0,	2,	PARAM_EXPSTRING,	PARAM_EXPRESSION,	IDS_ACTSETOBJANGLE_P0,	IDS_ACTSETOBJANGLE_P1,
	IDMN_ACTSETOBJANGVEL,	IDS_ACTSETOBJANGVEL,	ACT_ACTSETOBJANGVEL,	0,	3,	PARAM_EXPSTRING,	PARAM_EXPRESSION,	PARAM_EXPRESSION,	IDS_ACTSETOBJANGVEL_P0,	IDS_ACTSETOBJANGVEL_P1,	IDS_ACTSETOBJANGVEL_P2,
	IDMN_ACTSETOBJLINVEL,	IDS_ACTSETOBJLINVEL,	ACT_ACTSETOBJLINVEL,	0,	3,	PARAM_EXPSTRING,	PARAM_EXPRESSION,	PARAM_EXPRESSION,	IDS_ACTSETOBJLINVEL_P0,	IDS_ACTSETOBJLINVEL_P1,	IDS_ACTSETOBJLINVEL_P2,
	IDMN_ACTSETOBJMASS,	IDS_ACTSETOBJMASS,	ACT_ACTSETOBJMASS,	0,	2,	PARAM_EXPSTRING,	PARAM_EXPRESSION,	IDS_ACTSETOBJMASS_P0,	IDS_ACTSETOBJMASS_P1,
	IDMN_ACTSETOBJGRAVITYMODE,	IDS_ACTSETOBJGRAVITYMODE,	ACT_ACTSETOBJGRAVITYMODE,	0,	1,	PARAM_EXPRESSION,	IDS_ACTSETOBJGRAVITYMODE_P0,
	IDMN_ACTSETOBJBOUNCECOEFF,	IDS_ACTSETOBJBOUNCECOEFF,	ACT_ACTSETOBJBOUNCECOEFF,	0,	2,	PARAM_EXPSTRING,	PARAM_EXPRESSION,	IDS_ACTSETOBJBOUNCECOEFF_P0,	IDS_ACTSETOBJBOUNCECOEFF_P1,
	IDMN_ACTSETOBJFRICTIONCOEFF,	IDS_ACTSETOBJFRICTIONCOEFF,	ACT_ACTSETOBJFRICTIONCOEFF,	0,	2,	PARAM_EXPSTRING,	PARAM_EXPRESSION,	IDS_ACTSETOBJFRICTIONCOEFF_P0,	IDS_ACTSETOBJFRICTIONCOEFF_P1,
	IDMN_ACTSETOBJSOFTCOEFF,	IDS_ACTSETOBJSOFTCOEFF,	ACT_ACTSETOBJSOFTCOEFF,	0,	2,	PARAM_EXPSTRING,	PARAM_EXPRESSION,	IDS_ACTSETOBJSOFTCOEFF_P0,	IDS_ACTSETOBJSOFTCOEFF_P1,
	IDMN_ACTSETOBJAUTODISABLEFLAG,	IDS_ACTSETOBJAUTODISABLEFLAG,	ACT_ACTSETOBJAUTODISABLEFLAG,	0,	2,	PARAM_EXPSTRING,	PARAM_EXPRESSION,	IDS_ACTSETOBJAUTODISABLEFLAG_P0,	IDS_ACTSETOBJAUTODISABLEFLAG_P1,
	IDMN_ACTSETOBJSTATICFLAG,	IDS_ACTSETOBJSTATICFLAG,	ACT_ACTSETOBJSTATICFLAG,	0,	2,	PARAM_EXPSTRING,	PARAM_EXPRESSION,	IDS_ACTSETOBJSTATICFLAG_P0,	IDS_ACTSETOBJSTATICFLAG_P1,
	IDMN_ACTSETOBJENABLEDFLAG,	IDS_ACTSETOBJENABLEDFLAG,	ACT_ACTSETOBJENABLEDFLAG,	0,	2,	PARAM_EXPSTRING,	PARAM_EXPRESSION,	IDS_ACTSETOBJENABLEDFLAG_P0,	IDS_ACTSETOBJENABLEDFLAG_P1,
	IDMN_ACTADDOBJFORCE,	IDS_ACTADDOBJFORCE,	ACT_ACTADDOBJFORCE,	0,	3,	PARAM_EXPSTRING,	PARAM_EXPRESSION,	PARAM_EXPRESSION,	IDS_ACTADDOBJFORCE_P0,	IDS_ACTADDOBJFORCE_P1,	IDS_ACTADDOBJFORCE_P2,
	IDMN_ACTADDOBJRELFORCE,	IDS_ACTADDOBJRELFORCE,	ACT_ACTADDOBJRELFORCE,	0,	3,	PARAM_EXPSTRING,	PARAM_EXPRESSION,	PARAM_EXPRESSION,	IDS_ACTADDOBJRELFORCE_P0,	IDS_ACTADDOBJRELFORCE_P1,	IDS_ACTADDOBJRELFORCE_P2,
	IDMN_ACTADDOBJTORQUE,	IDS_ACTADDOBJTORQUE,	ACT_ACTADDOBJTORQUE,	0,	3,	PARAM_EXPSTRING,	PARAM_EXPRESSION,	PARAM_EXPRESSION,	IDS_ACTADDOBJTORQUE_P0,	IDS_ACTADDOBJTORQUE_P1,	IDS_ACTADDOBJTORQUE_P2,
	IDMN_ACTADDOBJRELTORQUE,	IDS_ACTADDOBJRELTORQUE,	ACT_ACTADDOBJRELTORQUE,	0,	3,	PARAM_EXPSTRING,	PARAM_EXPRESSION,	PARAM_EXPRESSION,	IDS_ACTADDOBJRELTORQUE_P0,	IDS_ACTADDOBJRELTORQUE_P1,	IDS_ACTADDOBJRELTORQUE_P2,
	IDMN_ACTADDSLIDERJOINT,	IDS_ACTADDSLIDERJOINT,	ACT_ACTADDSLIDERJOINT,	0,	3,	PARAM_EXPSTRING,	PARAM_EXPSTRING,	PARAM_EXPRESSION,	IDS_ACTADDSLIDERJOINT_P0,	IDS_ACTADDSLIDERJOINT_P1,	IDS_ACTADDSLIDERJOINT_P2,
	IDMN_ACTADDHINGEJOINT,	IDS_ACTADDHINGEJOINT,	ACT_ACTADDHINGEJOINT,	0,	3,	PARAM_EXPSTRING,	PARAM_EXPSTRING,	PARAM_EXPSTRING,	IDS_ACTADDHINGEJOINT_P0,	IDS_ACTADDHINGEJOINT_P1,	IDS_ACTADDHINGEJOINT_P2,
	IDMN_ACTSETJOINTRIGIDITY,	IDS_ACTSETJOINTRIGIDITY,	ACT_ACTSETJOINTRIGIDITY,	0,	3,	PARAM_EXPSTRING,	PARAM_EXPRESSION,	PARAM_EXPRESSION,	IDS_ACTSETJOINTRIGIDITY_P0,	IDS_ACTSETJOINTRIGIDITY_P1,	IDS_ACTSETJOINTRIGIDITY_P2,
	IDMN_ACTREMOVEJOINT,	IDS_ACTREMOVEJOINT,	ACT_ACTREMOVEJOINT,	0,	3,	PARAM_EXPSTRING,	PARAM_EXPSTRING,	PARAM_EXPSTRING,	IDS_ACTREMOVEJOINT_P0,	IDS_ACTREMOVEJOINT_P1,	IDS_ACTREMOVEJOINT_P2,
	IDMN_ACTCLEARERROR,	IDS_ACTCLEARERROR,	ACT_ACTCLEARERROR,	0,	0,
};

// Definitions of parameters for each expression
short expressionsInfos[]=
{
	IDMN_EXPGETID,	IDS_EXPGETID,	EXP_EXPGETID,	EXPFLAG_STRING,	0,
	IDMN_EXPGETERP,	IDS_EXPGETERP,	EXP_EXPGETERP,	EXPFLAG_DOUBLE,	0,
	IDMN_EXPGETCFM,	IDS_EXPGETCFM,	EXP_EXPGETCFM,	EXPFLAG_DOUBLE,	0,
	IDMN_EXPGETGRAVX,	IDS_EXPGETGRAVX,	EXP_EXPGETGRAVX,	EXPFLAG_DOUBLE,	0,
	IDMN_EXPGETGRAVY,	IDS_EXPGETGRAVY,	EXP_EXPGETGRAVY,	EXPFLAG_DOUBLE,	0,
	IDMN_EXPGETBORDERSTATE,	IDS_EXPGETBORDERSTATE,	EXP_EXPGETBORDERSTATE,	0,	0,
	IDMN_EXPGETAUTOUPSTATE,	IDS_EXPGETAUTOUPSTATE,	EXP_EXPGETAUTOUPSTATE,	0,	0,
	IDMN_EXPGETOBJXCENTER,	IDS_EXPGETOBJXCENTER,	EXP_EXPGETOBJXCENTER,	EXPFLAG_DOUBLE,	1,	EXPPARAM_STRING,	IDS_EXPGETOBJXCENTER_P0,
	IDMN_EXPGETOBJYCENTER,	IDS_EXPGETOBJYCENTER,	EXP_EXPGETOBJYCENTER,	EXPFLAG_DOUBLE,	0,
	IDMN_EXPGETOBJXPOS,	IDS_EXPGETOBJXPOS,	EXP_EXPGETOBJXPOS,	EXPFLAG_DOUBLE,	1,	EXPPARAM_STRING,	IDS_EXPGETOBJXPOS_P0,
	IDMN_EXPGETOBJYPOS,	IDS_EXPGETOBJYPOS,	EXP_EXPGETOBJYPOS,	EXPFLAG_DOUBLE,	1,	EXPPARAM_STRING,	IDS_EXPGETOBJYPOS_P0,
	IDMN_EXPGETOBJANG,	IDS_EXPGETOBJANG,	EXP_EXPGETOBJANG,	EXPFLAG_DOUBLE,	1,	EXPPARAM_STRING,	IDS_EXPGETOBJANG_P0,
	IDMN_EXPGETOBJANGVELX,	IDS_EXPGETOBJANGVELX,	EXP_EXPGETOBJANGVELX,	EXPFLAG_DOUBLE,	1,	EXPPARAM_STRING,	IDS_EXPGETOBJANGVELX_P0,
	IDMN_EXPGETOBJANGVELY,	IDS_EXPGETOBJANGVELY,	EXP_EXPGETOBJANGVELY,	EXPFLAG_DOUBLE,	1,	EXPPARAM_STRING,	IDS_EXPGETOBJANGVELY_P0,
	IDMN_EXPGETOBJLINVELX,	IDS_EXPGETOBJLINVELX,	EXP_EXPGETOBJLINVELX,	EXPFLAG_DOUBLE,	1,	EXPPARAM_STRING,	IDS_EXPGETOBJLINVELX_P0,
	IDMN_EXPGETOBJLINVELY,	IDS_EXPGETOBJLINVELY,	EXP_EXPGETOBJLINVELY,	EXPFLAG_DOUBLE,	1,	EXPPARAM_STRING,	IDS_EXPGETOBJLINVELY_P0,
	IDMN_EXPGETOBJMASS,	IDS_EXPGETOBJMASS,	EXP_EXPGETOBJMASS,	EXPFLAG_DOUBLE,	1,	EXPPARAM_STRING,	IDS_EXPGETOBJMASS_P0,
	IDMN_EXPGETOBJGRAVMODE,	IDS_EXPGETOBJGRAVMODE,	EXP_EXPGETOBJGRAVMODE,	0,	1,	EXPPARAM_STRING,	IDS_EXPGETOBJGRAVMODE_P0,
	IDMN_EXPGETOBJBOUNCECOEFF,	IDS_EXPGETOBJBOUNCECOEFF,	EXP_EXPGETOBJBOUNCECOEFF,	EXPFLAG_DOUBLE,	1,	EXPPARAM_STRING,	IDS_EXPGETOBJBOUNCECOEFF_P0,
	IDMN_EXPGETOBJFRICCOEFF,	IDS_EXPGETOBJFRICCOEFF,	EXP_EXPGETOBJFRICCOEFF,	EXPFLAG_DOUBLE,	1,	EXPPARAM_STRING,	IDS_EXPGETOBJFRICCOEFF_P0,
	IDMN_EXPGETOBJSOFTCOEFF,	IDS_EXPGETOBJSOFTCOEFF,	EXP_EXPGETOBJSOFTCOEFF,	EXPFLAG_DOUBLE,	1,	EXPPARAM_STRING,	IDS_EXPGETOBJSOFTCOEFF_P0,
	IDMN_EXPGETOBJAUTODISABLESTATE,	IDS_EXPGETOBJAUTODISABLESTATE,	EXP_EXPGETOBJAUTODISABLESTATE,	0,	1,	EXPPARAM_STRING,	IDS_EXPGETOBJAUTODISABLESTATE_P0,
	IDMN_EXPGETOBJSTATICSTATE,	IDS_EXPGETOBJSTATICSTATE,	EXP_EXPGETOBJSTATICSTATE,	0,	1,	EXPPARAM_STRING,	IDS_EXPGETOBJSTATICSTATE_P0,
	IDMN_EXPGETOBJENABLESTATE,	IDS_EXPGETOBJENABLESTATE,	EXP_EXPGETOBJENABLESTATE,	0,	1,	EXPPARAM_STRING,	IDS_EXPGETOBJENABLESTATE_P0,
	IDMN_EXPGETJOINTCOUNT,	IDS_EXPGETJOINTCOUNT,	EXP_EXPGETJOINTCOUNT,	0,	1,	EXPPARAM_STRING,	IDS_EXPGETJOINTCOUNT_P0,
	IDMN_EXPGETJOINTSPRINGCONSTANT,	IDS_EXPGETJOINTSPRINGCONSTANT,	EXP_EXPGETJOINTSPRINGCONSTANT,	EXPFLAG_DOUBLE,	1,	EXPPARAM_STRING,	IDS_EXPGETJOINTSPRINGCONSTANT_P0,
	IDMN_EXPGETJOINTDAMPINGCONSTANT,	IDS_EXPGETJOINTDAMPINGCONSTANT,	EXP_EXPGETJOINTDAMPINGCONSTANT,	EXPFLAG_DOUBLE,	1,	EXPPARAM_STRING,	IDS_EXPGETJOINTDAMPINGCONSTANT_P0,
	IDMN_EXPGETERRORMESSAGE,	IDS_EXPGETERRORMESSAGE,	EXP_EXPGETERRORMESSAGE,	EXPFLAG_STRING,	0,
};


// ----------------------------------------------------------
// Condition / Action / Expression jump table
// ----------------------------------------------------------
// Contains the address inside the extension of the different
// routines that handle the action, conditions and expressions.
// Located at the end of the source for convinience
// Must finish with a 0
//
long (WINAPI * ConditionJumps[])(LPRDATA rdPtr, long param1, long param2) = 
{ 
	conOnObj,
	conOnCollision,
	conObjEnabled,
	conOnError,
	0
};

short (WINAPI * ActionJumps[])(LPRDATA rdPtr, long param1, long param2) =
{
	actLoadWorld,
	actAddObject,
	actSetGlobalERP,
	actSetGlobalCFM,
	actSetGravity,
	actSetBorderFlag,
	actSetAutoUpdateFlag,
	actUpdateWorld,
	actAddBoxToObj,
	actAddCircleToObj,
	actSetObjCenter,
	actRemovePrimitive,
	actSetActive,
	actSetObjX,
	actSetObjY,
	actSetObjAngle,
	actSetObjAngVel,
	actSetObjLinVel,
	actSetObjMass,
	actSetObjGravityMode,
	actSetObjBounceCoeff,
	actSetObjFrictionCoeff,
	actSetObjSoftCoeff,
	actSetObjAutoDisableFlag,
	actSetObjStaticFlag,
	actSetObjEnabledFlag,
	actAddObjForce,
	actAddObjRelForce,
	actAddObjTorque,
	actAddObjRelTorque,
	actAddSliderJoint,
	actAddHingeJoint,
	actSetJointRigidity,
	actRemoveJoint,
	actClearError,
	0
};

long (WINAPI * ExpressionJumps[])(LPRDATA rdPtr, long param) = 
{     
	expGetID,
	expGetERP,
	expGetCFM,
	expGetGravX,
	expGetGravY,
	expGetBorderState,
	expGetAutoUpState,
	expGetObjXCenter,
	expGetObjYCenter,
	expGetObjXPos,
	expGetObjYPos,
	expGetObjAng,
	expGetObjAngVelX,
	expGetObjAngVelY,
	expGetObjLinVelX,
	expGetObjLinVelY,
	expGetObjMass,
	expGetObjGravMode,
	expGetObjBounceCoeff,
	expGetObjFricCoeff,
	expGetObjSoftCoeff,
	expGetObjAutoDisableState,
	expGetObjStaticState,
	expGetObjEnableState,
	expGetJointCount,
	expGetJointSpringConstant,
	expGetJointDampingConstant,
	expGetErrorMessage,
	0
};