//Welcome to your auto-generated extension template!
//The first thing you should do is set the active build to debug in the projects menu
//Then build! If there are errors try and find out what caused them
//then check to see it is because of what you typed in in your .aces file

//Use the handy transfer.bat file in the debug directory of the SDK to transfer the cox files to MMF (Close down any projects using the extension first)
//You can get all sorts of crashes if your interface code is wrong so check everything thouroughly or pay later!
//Check each condition, action and expression can be placed and make sure each expression is valid by using the validify button in the expression editor

//If all goes well, happy making!
//What you still need to do :
//	Change the 3 extension build filenames (Project->Settings->V2Template32->Link)
//	Make your icons
//	Make your setup box
//	Fill out your extension info and author info in the string tables
//	Change your version info in the resource file
//	Change your IDENTIFIER, flags and prefrences in main.h
//	Change your runtime data and edittime data structures to suit your needs
//	Fill out all the required routines in Runtime.cpp and Edittime.cpp
//	Flesh out your actions, conditions and expressions
//	Write help files, examples and documentation!



// ============================================================================
//
// This file are where the Conditions/Actions/Expressions are defined.
//
// ============================================================================
// Common Include
#include "DynProp.hpp"

// Quick memo: content of the eventInformations arrays
// ---------------------------------------------------
// Menu ID
// String ID
// Code
// Flags
// Number_of_parameters
// Parameter_type [Number_of_parameters]
// Parameter_TitleString [Number_of_parameters]


short conditionsInfos[]=
{ 
	CID_conLoadSuc,	CID_conLoadSuc,	0,	EVFLAGS_ALWAYS | EVFLAGS_NOTABLE,	0,
		CID_conOnElement,	CID_conOnElement,	1,	0,	0,
		CID_conOnComment,	CID_conOnComment,	2,	0,	0,
		CID_conOnUnknown,	CID_conOnUnknown,	3,	0,	0,
		CID_conOnText,	CID_conOnText,	4,	0,	0,
		CID_conHasChild,	CID_conHasChild,	5,	EVFLAGS_ALWAYS | EVFLAGS_NOTABLE,	0,
		CID_conOnError,	CID_conOnError,	6,	0,	0,
		CID_conOnAttrib,CID_conOnAttrib,7,0,0,
		0 };
	
	short actionsInfos[]=
	{ 
		AID_actLoadFile,	AID_actLoadFile,	0,	0,	1,	PARAM_EXPSTRING,	AP0ID_actLoadFile,
			AID_actSaveFile,	AID_actSaveFile,	1,	0,	1,	PARAM_EXPSTRING,	AP0ID_actSaveFile,
			AID_actParse,	AID_actParse,	2,	0,	1,	PARAM_EXPSTRING,	AP0ID_actParse,
			AID_actSetKey,	AID_actSetKey,	3,	0,	1,	PARAM_EXPSTRING,	AP0ID_actSetKey,
			AID_actLoadEncFile,	AID_actLoadEncFile,	4,	0,	1,	PARAM_EXPSTRING,	AP0ID_actLoadEncFile,
			AID_actSaveEncFile,	AID_actSaveEncFile,	5,	0,	1,	PARAM_EXPSTRING,	AP0ID_actSaveEncFile,
			AID_actStartParsing,	AID_actStartParsing,	6,	0,	0,
			AID_actStopParsing,	AID_actStopParsing,	7,	0,	0,
			AID_actSetValue,	AID_actSetValue,	8,	0,	1,	PARAM_EXPSTRING,	AP0ID_actSetValue,
			AID_actRoot,	AID_actRoot,	9,	0,	0,
			AID_actFirstChild,	AID_actFirstChild,	10,	0,	0,
			AID_actFindChild,	AID_actFindChild,	11,	0,	1,	PARAM_EXPSTRING,	AP0ID_actFindChild,
			AID_actLastChild,	AID_actLastChild,	12,	0,	0,
			AID_actNextSibling,	AID_actNextSibling,	13,	0,	0,
			AID_actFindSibling,	AID_actFindSibling,	14,	0,	1,	PARAM_EXPSTRING,	AP0ID_actFindSibling,
			AID_actPreviousSibling,	AID_actPreviousSibling,	15,	0,	0,
			AID_actParentNode,	AID_actParentNode,	16,	0,	0,
			AID_actDeleteChildren,	AID_actDeleteChildren,	17,	0,	0,
			AID_actDeleteChild,	AID_actDeleteChild,	18,	0,	1,	PARAM_EXPSTRING,	AP0ID_actDeleteChild,
			AID_actAddElem,	AID_actAddElem,	19,	0,	1,	PARAM_EXPSTRING,	AP0ID_actAddElem,
			AID_actElemSetName,	AID_actElemSetName,	20,	0,	1,	PARAM_EXPSTRING,	AP0ID_actElemSetName,
			AID_actElemAtribStr,	AID_actElemAtribStr,	21,	0,	2,	PARAM_EXPSTRING,	PARAM_EXPSTRING,	AP0ID_actElemAtribStr,	AP1ID_actElemAtribStr,
			AID_actElemAtribVal,	AID_actElemAtribVal,	22,	0,	2,	PARAM_EXPSTRING,	PARAM_EXPRESSION,	AP0ID_actElemAtribVal,	AP1ID_actElemAtribVal,
			AID_actAddCom,	AID_actAddCom,	23,	0,	1,	PARAM_EXPSTRING,	AP0ID_actAddCom,
			AID_actSetCom,	AID_actSetCom,	24,	0,	1,	PARAM_EXPSTRING,	AP0ID_actSetCom,
			AID_actAddText,	AID_actAddText,	25,	0,	1,	PARAM_EXPSTRING,	AP0ID_actAddText,
			AID_actSetText,	AID_actSetText,	26,	0,	1,	PARAM_EXPSTRING,	AP0ID_actSetText,
			AID_actClearError,	AID_actClearError,	27,	0,	0,
			AID_actNodeIndex,AID_actNodeIndex,28,0,1,PARAM_EXPRESSION,AP0ID_actNodeIndex,
			AID_actSibIndex,AID_actSibIndex,29,0,1,PARAM_EXPRESSION,AP0ID_actSibIndex,
			AID_actChildIndex,AID_actChildIndex,30,0,1,PARAM_EXPRESSION,AP0ID_actChildIndex,
			AID_actRemoveAttrib,AID_actRemoveAttrib,31,0,1,PARAM_EXPSTRING,AP0ID_actRemoveAttrib,
			AID_actDeleteNode,AID_actDeleteNode,32,0,0,
			0 };
		
		short expressionsInfos[]=
		{ 
			EID_expressionGetFileName,	EID_expressionGetFileName,	0,	EXPFLAG_STRING,	0,
				EID_expGetAutoNodeIndex,	EID_expGetAutoNodeIndex,	1,	0,	0,
				EID_expNodeGetValue,	EID_expNodeGetValue,	2,	EXPFLAG_STRING,	0,
				EID_expNodeGetType,	EID_expNodeGetType,	3,	0,	0,
				EID_expElemGetName,	EID_expElemGetName,	4,	EXPFLAG_STRING,	0,
				EID_expElemGetAttribStr,	EID_expElemGetAttribStr,	5,	EXPFLAG_STRING,	1,	EXPPARAM_STRING,	0,
				EID_expElemGetAttribVal,	EID_expElemGetAttribVal,	6,	0,	1,	EXPPARAM_STRING,	0,
				EID_expParentName,	EID_expParentName,	7,	EXPFLAG_STRING,	0,
				EID_expParentAttribStr,	EID_expParentAttribStr,	8,	EXPFLAG_STRING,	1,	EXPPARAM_STRING,	0,
				EID_expParentAttribVal,	EID_expParentAttribVal,	9,	0,	1,	EXPPARAM_STRING,	0,
				EID_expGetComStr,	EID_expGetComStr,	10,	EXPFLAG_STRING,	0,
				EID_expGetText,	EID_expGetText,	11,	EXPFLAG_STRING,	0,
				EID_expUnknownGetText,	EID_expUnknownGetText,	12,	EXPFLAG_STRING,	0,
				EID_expGetErrorStr,	EID_expGetErrorStr,	13,	EXPFLAG_STRING,	0,
				EID_expGetErrorID,	EID_expGetErrorID,	14,	0,	0,
				EID_expGetErrorRow,	EID_expGetErrorRow,	15,	0,	0,
				EID_expGetErrorCol,	EID_expGetErrorCol,	16,	0,	0,
				EID_expGetDocText,EID_expGetDocText,17,EXPFLAG_STRING,0,
				EID_expGetChildText,EID_expGetChildText,18,EXPFLAG_STRING,0,
				EID_expGetChildNum,EID_expGetChildNum,19,0,0,
				EID_expGetParChildNum,EID_expGetParChildNum,20,0,0,
				EID_expGetTotalNode,EID_expGetTotalNode,21,0,0,
				EID_expGetNodeIndex,EID_expGetNodeIndex,22,0,0,
				EID_expGetNodeRelIndex,EID_expGetNodeRelIndex,23,0,0,
				EID_expGetDepth,EID_expGetDepth,24,0,0,
				EID_expAttribIndex,EID_expAttribIndex,25,0,0,
				EID_expAttribName,EID_expAttribName,26,EXPFLAG_STRING,1,EXPPARAM_LONG,0,
				EID_expAttribTotal,EID_expAttribTotal,27,0,0,
				0 };
			
			
			
			//============================================================================
			//
			// CONDITION ROUTINES
			// 
			// ============================================================================
			
			
			long WINAPI DLLExport conLoadSuc(LPRDATA rdPtr, long param1, long param2)
			{
				return rdPtr->LoadSuc;
			}
			
			long WINAPI DLLExport conOnElement(LPRDATA rdPtr, long param1, long param2)
			{
				return TRUE;
			}
			
			long WINAPI DLLExport conOnComment(LPRDATA rdPtr, long param1, long param2)
			{
				return TRUE;
			}
			
			long WINAPI DLLExport conOnUnknown(LPRDATA rdPtr, long param1, long param2)
			{
				return TRUE;
			}
			
			long WINAPI DLLExport conOnText(LPRDATA rdPtr, long param1, long param2)
			{
				return TRUE;
			}
			long WINAPI DLLExport conOnAttrib(LPRDATA rdPtr, long param1, long param2)
			{
				return TRUE;
			}
			long WINAPI DLLExport conHasChild(LPRDATA rdPtr, long param1, long param2)
			{
				return !rdPtr->myNode->NoChildren();
			}
			
			long WINAPI DLLExport conOnError(LPRDATA rdPtr, long param1, long param2)
			{
				return TRUE;
			}
			
			
			
			
			//============================================================================
			//
			// ACTIONS ROUTINES
			// 
			// ============================================================================
			int ParseElement(LPRDATA rdPtr,TiXmlNode*elem);
			int IterateAttrib(LPRDATA rdPtr,TiXmlNode*elem);
			int CallTypes(LPRDATA rdPtr,TiXmlNode*Node)
			{
				rdPtr->nodeindex++;
				if(Node->Type()==1)
				{
					callRunTimeFunction(rdPtr, RFUNCTION_GENERATEEVENT, 1, 0);
					IterateAttrib(rdPtr,Node);
				}	
				//text
				if(Node->Type()==4)
				{
					callRunTimeFunction(rdPtr, RFUNCTION_GENERATEEVENT, 4, 0);
				}
				//unknown
				if(Node->Type()==3)
				{
					callRunTimeFunction(rdPtr, RFUNCTION_GENERATEEVENT, 3, 0);
				}
				//comment
				if(Node->Type()==2)
				{
					callRunTimeFunction(rdPtr, RFUNCTION_GENERATEEVENT, 2, 0);
				}
				return 0;
			}
			int IterateAttrib(LPRDATA rdPtr,TiXmlNode*elem)
			{
				TiXmlAttribute* tAttrib;
				rdPtr->attribindex=0;
				if(elem->Type()==1)
				{
					if(elem->ToElement()->FirstAttribute()!=NULL)
					{
					tAttrib=elem->ToElement()->FirstAttribute();
					callRunTimeFunction(rdPtr, RFUNCTION_GENERATEEVENT, 7, 0);
					while(tAttrib->Next()!=NULL)
					{
						tAttrib=tAttrib->Next();
						rdPtr->attribindex++;
						callRunTimeFunction(rdPtr, RFUNCTION_GENERATEEVENT, 7, 0);
					}
					}

				}
				return 0;
			}
			int ParseElement(LPRDATA rdPtr,TiXmlNode*elem)
			{
				TiXmlNode *child=0;
				while(child=elem->IterateChildren(child))
				{
					rdPtr->nodeindex++;
					rdPtr->myNode=child;
					//element
					if(child->Type()==1)
					{
						callRunTimeFunction(rdPtr, RFUNCTION_GENERATEEVENT, 1, 0);
						IterateAttrib(rdPtr,child);
						ParseElement(rdPtr,child);
					}	
					//text
					if(child->Type()==4)
					{
						callRunTimeFunction(rdPtr, RFUNCTION_GENERATEEVENT, 4, 0);
					}
					//unknown
					if(child->Type()==3)
					{
						callRunTimeFunction(rdPtr, RFUNCTION_GENERATEEVENT, 3, 0);
					}
					//comment
					if(child->Type()==2)
					{
						callRunTimeFunction(rdPtr, RFUNCTION_GENERATEEVENT, 2, 0);
					}
					if(rdPtr->Run==false)
					{
						break;
					}
				}
				return 0;
			}
			
			
			short WINAPI DLLExport actLoadFile(LPRDATA rdPtr, long param1, long param2)
			{
				char * p1=(LPSTR)param1;
				rdPtr->LoadSuc=rdPtr->myDoc->LoadFile(p1);
				rdPtr->myNode=rdPtr->myDoc->FirstChild();
				return 0;
			}
			
			short WINAPI DLLExport actSaveFile(LPRDATA rdPtr, long param1, long param2)
			{
				char * p1=(LPSTR)param1;
				rdPtr->myDoc->SaveFile(p1);
				return 0;
			}
			
			short WINAPI DLLExport actParse(LPRDATA rdPtr, long param1, long param2)
			{
				char * p1=(LPSTR)param1;
				rdPtr->myDoc->Clear();
				rdPtr->myDoc->Parse(p1);
				rdPtr->myNode=rdPtr->myDoc->FirstChild();
				return 0;
			}
			
			short WINAPI DLLExport actSetKey(LPRDATA rdPtr, long param1, long param2)
			{
				char * p1=(LPSTR)param1;
				char*vor="1111";
				rdPtr->key=p1;
				while(rdPtr->key.length()<4)
				{
					rdPtr->key+=vor[rdPtr->key.length()];
				}
				return 0;
			}
			
			short WINAPI DLLExport actLoadEncFile(LPRDATA rdPtr, long param1, long param2)
			{
				char * p1=(LPSTR)param1;
				long length = 0;
				char *buffer;
				FILE *myFile;
				CBlowFish oBlowFish((unsigned char*)(rdPtr->key.c_str()),rdPtr->key.length());
				myFile=fopen(p1,"rb");
				
				if(myFile!=NULL)
				{
					fseek( myFile, 0, SEEK_END );
					length = ftell( myFile );
					if(length>0)
					{
					buffer = (char*) malloc (length);
					rewind(myFile);
					fread (buffer,1,length,myFile);
					fclose(myFile);
					oBlowFish.Decrypt((unsigned char*)buffer,ceil((length)/8.0)*8,CBlowFish::ECB);
					rdPtr->myDoc->Clear();
					rdPtr->myDoc->Parse(buffer);
					rdPtr->myNode=rdPtr->myDoc->FirstChild();
					free(buffer);
					}
				}
				fclose(myFile);
				return 0;
			}
			TiXmlString get_xml_string (const TiXmlNode * node) 
			{ 
				TiXmlString s; 
				TiXmlOutStream os_stream; 
				os_stream << * node; 
				s = os_stream; 
				return s; 
			} 
			
			short WINAPI DLLExport actSaveEncFile(LPRDATA rdPtr, long param1, long param2)
			{
				char * p1=(LPSTR)param1;
				TiXmlString* buffer;
				FILE *myFile;
				TiXmlNode*Node;
				myFile=fopen(p1,"wb");
				if(myFile!=NULL)
				{
					buffer=new TiXmlString();
					Node=rdPtr->myDoc->FirstChild();
					if(Node!=NULL)
					{
					*buffer=get_xml_string(Node);
					while(Node->NextSibling()!=NULL)
					{
						Node=Node->NextSibling();
						(*buffer)+=get_xml_string(Node);
					
					}
					CBlowFish myBlow((unsigned char*)(rdPtr->key.c_str()),rdPtr->key.length());
					myBlow.ResetChain();
					myBlow.Encrypt((unsigned char*)(buffer->c_str()),(double)ceil((double)((buffer->length())/8.0))*8,CBlowFish::ECB);
					rewind(myFile);
					fputs((const char*)buffer->c_str(),myFile);
					fclose(myFile);
					delete buffer;
					}	
				}
				
				return 0;
			}
			
			short WINAPI DLLExport actStartParsing(LPRDATA rdPtr, long param1, long param2)
			{
				rdPtr->Run=true;
				TiXmlNode*Node;
				if(rdPtr->myNode!=NULL)
				{
				Node=rdPtr->myDoc->FirstChild();
				if(Node!=NULL)
				{
					rdPtr->myNode=Node;
					rdPtr->nodeindex=0;
					CallTypes(rdPtr,Node);
					ParseElement(rdPtr,Node);
					while(Node->NextSibling()!=NULL)
					{
						Node=Node->NextSibling();
						rdPtr->myNode=Node;
						CallTypes(rdPtr,Node);
						ParseElement(rdPtr,Node);
						if(rdPtr->Run==false)
						{
							break;
						}
					}
				}
				}
				return 0;
			}
			
			short WINAPI DLLExport actStopParsing(LPRDATA rdPtr, long param1, long param2)
			{
				rdPtr->Run=false;
				return 0;
			}
			
			short WINAPI DLLExport actSetValue(LPRDATA rdPtr, long param1, long param2)
			{
				char * p1=(LPSTR)param1;
				if(rdPtr->myNode!=NULL)
				{
					rdPtr->myNode->SetValue(p1);
				}
				return 0;
			}
			
			short WINAPI DLLExport actRoot(LPRDATA rdPtr, long param1, long param2)
			{
				if(rdPtr->myNode!=NULL&&rdPtr->myDoc->FirstChild()!=NULL)
				{
					rdPtr->myNode=rdPtr->myDoc->FirstChild();
				}
				return 0;
			}
			
			short WINAPI DLLExport actFirstChild(LPRDATA rdPtr, long param1, long param2)
			{
				if(rdPtr->myNode!=NULL&&rdPtr->myNode->FirstChild()!=NULL)
				{
					rdPtr->myNode=rdPtr->myNode->FirstChild();
				}
				return 0;
			}
			
			short WINAPI DLLExport actFindChild(LPRDATA rdPtr, long param1, long param2)
			{
				char * p1=(LPSTR)param1;
				if(rdPtr->myNode!=NULL&&rdPtr->myNode->FirstChild(p1)!=NULL)
				{
					rdPtr->myNode=rdPtr->myNode->FirstChild(p1);
				}
				return 0;
			}
			
			short WINAPI DLLExport actLastChild(LPRDATA rdPtr, long param1, long param2)
			{
				if(rdPtr->myNode!=NULL&&rdPtr->myNode->LastChild()!=NULL)
				{
					rdPtr->myNode=rdPtr->myNode->LastChild();
				}
				return 0;
			}
			
			short WINAPI DLLExport actNextSibling(LPRDATA rdPtr, long param1, long param2)
			{
				if(rdPtr->myNode!=NULL&&rdPtr->myNode->NextSibling()!=NULL)
				{
					rdPtr->myNode=rdPtr->myNode->NextSibling();
				}
				return 0;
			}
			
			short WINAPI DLLExport actFindSibling(LPRDATA rdPtr, long param1, long param2)
			{
				char * p1=(LPSTR)param1;
				if(rdPtr->myNode!=NULL&&rdPtr->myNode->NextSibling(p1)!=NULL)
				{
					rdPtr->myNode=rdPtr->myNode->NextSibling(p1);
				}
				return 0;
			}
			
			short WINAPI DLLExport actPreviousSibling(LPRDATA rdPtr, long param1, long param2)
			{
				if(rdPtr->myNode!=NULL&&rdPtr->myNode->PreviousSibling()!=NULL)
				{
					rdPtr->myNode=rdPtr->myNode->PreviousSibling();
				}
				return 0;
			}
			
			short WINAPI DLLExport actParentNode(LPRDATA rdPtr, long param1, long param2)
			{
				if(rdPtr->myNode!=NULL&&rdPtr->myNode->Parent()!=NULL)
				{
					rdPtr->myNode=rdPtr->myNode->Parent();
				}
				return 0;
			}
			
			short WINAPI DLLExport actDeleteChildren(LPRDATA rdPtr, long param1, long param2)
			{
				if(rdPtr->myNode!=NULL)
				{
				rdPtr->myNode->Clear();
				}
				return 0;
			}
			
			short WINAPI DLLExport actDeleteChild(LPRDATA rdPtr, long param1, long param2)
			{
				char * p1=(LPSTR)param1;
				TiXmlNode*Find;
				if(rdPtr->myNode!=NULL&&rdPtr->myNode->FirstChild(p1)!=NULL)
				{
					Find=rdPtr->myNode->FirstChild(p1);
					rdPtr->myNode->RemoveChild(Find);
				}
				return 0;
			}
			
			short WINAPI DLLExport actAddElem(LPRDATA rdPtr, long param1, long param2)
			{
				char * p1=(LPSTR)param1;
				if(rdPtr->myNode==NULL)
				{
					rdPtr->myDoc->LinkEndChild(new TiXmlElement(p1));
					rdPtr->myNode=rdPtr->myDoc->LastChild();
				}
				else
				{
					rdPtr->myNode->LinkEndChild(new TiXmlElement(p1));
					rdPtr->myNode=rdPtr->myNode->LastChild();
				}
				return 0;
			}
			
			short WINAPI DLLExport actElemSetName(LPRDATA rdPtr, long param1, long param2)
			{
				char * p1=(LPSTR)param1;
				if(rdPtr->myNode!=NULL&&rdPtr->myNode->Type()==1)
				{
					rdPtr->myNode->ToElement()->SetValue(p1);
				}
				return 0;
			}
			
			short WINAPI DLLExport actElemAtribStr(LPRDATA rdPtr, long param1, long param2)
			{
				char * p1=(LPSTR)param1;
				char * p2=(LPSTR)param2;
				if(rdPtr->myNode!=NULL&&rdPtr->myNode->Type()==1)
				{
					rdPtr->myNode->ToElement()->SetAttribute(p1,p2);
				}
				return 0;
			}
			
			short WINAPI DLLExport actElemAtribVal(LPRDATA rdPtr, long param1, long param2)
			{
				char * p1=(LPSTR)param1;
				//param2 contains the number inputed by the user
				if(rdPtr->myNode!=NULL&&rdPtr->myNode->Type()==1)
				{
					rdPtr->myNode->ToElement()->SetAttribute(p1,param2);
				}
				return 0;
			}
			
			short WINAPI DLLExport actAddCom(LPRDATA rdPtr, long param1, long param2)
			{
				char * p1=(LPSTR)param1;
				if(rdPtr->myNode!=NULL)
				{
					rdPtr->myNode->LinkEndChild(new TiXmlComment());
					rdPtr->myNode=rdPtr->myNode->LastChild();
					rdPtr->myNode->SetValue(p1);
				}
				else
				{
					rdPtr->myDoc->LinkEndChild(new TiXmlComment());
					rdPtr->myNode=rdPtr->myDoc->LastChild();
					rdPtr->myNode->SetValue(p1);
				}
				return 0;
			}
			
			short WINAPI DLLExport actSetCom(LPRDATA rdPtr, long param1, long param2)
			{
				char * p1=(LPSTR)param1;
				if(rdPtr->myNode!=NULL&&rdPtr->myNode->Type()==2)
				{
					rdPtr->myNode->ToComment()->SetValue(p1);
				}
				return 0;
			}
			
			short WINAPI DLLExport actAddText(LPRDATA rdPtr, long param1, long param2)
			{
				char * p1=(LPSTR)param1;
				if(rdPtr->myNode!=NULL)
				{
					rdPtr->myNode->LinkEndChild(new TiXmlText(p1));
					rdPtr->myNode=rdPtr->myNode->LastChild();
				}
				return 0;
			}
			
			short WINAPI DLLExport actSetText(LPRDATA rdPtr, long param1, long param2)
			{
				char * p1=(LPSTR)param1;
				if(rdPtr->myNode!=NULL&&rdPtr->myNode->Type()==4)
				{
					rdPtr->myNode->ToText()->SetValue(p1);
				}
				return 0;
			}
			
			short WINAPI DLLExport actClearError(LPRDATA rdPtr, long param1, long param2)
			{
				rdPtr->myDoc->ClearError();
				return 0;
			}
			int GetChild(LPRDATA rdPtr,TiXmlNode*elem)
			{
				TiXmlNode *child=0;
				if(rdPtr->nodemainindex==rdPtr->nodemaincount)
				{
					rdPtr->myNode=elem;
				}
				else
				{
				while(child=elem->IterateChildren(child))
				{
					//rdPtr->myNode=child;
					//element
					rdPtr->nodemaincount++;
					//MessageBox(NULL,"Child","Node found",NULL);
					if(rdPtr->nodemainindex==rdPtr->nodemaincount)
					{
						rdPtr->myNode=child;
					}
					if(child->Type()==1)
					{
						GetChild(rdPtr,child);
					}
				
				}
				}
				return 0;
			}
			short WINAPI DLLExport actNodeIndex(LPRDATA rdPtr, long param1, long param2)
			{
				TiXmlNode*node=0;
				node=rdPtr->myDoc->FirstChild();
				rdPtr->nodemaincount=0;
				rdPtr->nodemainindex=param1;
				if(node!=NULL)
				{
				if(rdPtr->nodemainindex==rdPtr->nodemaincount)
				{
					rdPtr->myNode=node;
				}				
				else
				{
				GetChild(rdPtr,node);
				while(node->NextSibling()!=NULL)
				{
					node=node->NextSibling();
					//MessageBox(NULL,"Sibling","Node found",NULL);
					rdPtr->nodemaincount++;		
					if(rdPtr->nodemainindex==rdPtr->nodemaincount)
					{
					rdPtr->myNode=node;
					break;
					}

					GetChild(rdPtr,node);
				}
				}
				}
				return 0;
			}			
			short WINAPI DLLExport actSibIndex(LPRDATA rdPtr, long param1, long param2)
			{
				rdPtr->nodemainindex=param1;
				rdPtr->nodemaincount=0;
				TiXmlNode*node=0;
				if(rdPtr->myNode!=NULL)
				{
				if(rdPtr->myNode->Parent()!=NULL)
				{
				node=rdPtr->myNode->Parent()->FirstChild();
				if(rdPtr->nodemainindex==rdPtr->nodemaincount)
				{
					rdPtr->myNode=node;
				}
				while(node->NextSibling()!=NULL)
				{
					node=node->NextSibling();
					rdPtr->nodemaincount++;
					if(rdPtr->nodemaincount==rdPtr->nodemainindex)
					{
						rdPtr->myNode=node;
					}

				}
				}
				}
				return 0;
			}			
			short WINAPI DLLExport actChildIndex(LPRDATA rdPtr, long param1, long param2)
			{
				TiXmlNode*node=0;
				rdPtr->nodemaincount=0;
				rdPtr->nodemainindex=param1;
				if(rdPtr->myNode!=NULL)
				{
				if(rdPtr->myNode->FirstChild()!=NULL)
				{
					node=rdPtr->myNode->FirstChild();
					if(rdPtr->nodemainindex==rdPtr->nodemaincount)
					{
					rdPtr->myNode=node;
					}
					while(node->NextSibling()!=NULL)
					{
						node=node->NextSibling();
						rdPtr->nodemaincount++;
						if(rdPtr->nodemainindex==rdPtr->nodemaincount)
						{
							rdPtr->myNode=node;
						}
					}
				}
				}
				return 0;
			}
			short WINAPI DLLExport actRemoveAttrib(LPRDATA rdPtr, long param1, long param2)
			{
				char * p1=(LPSTR)param1;
				if(rdPtr->myNode!=NULL&&rdPtr->myNode->Type()==1)
				{
					rdPtr->myNode->ToElement()->RemoveAttribute(p1);
				}
				return 0;
			}
			short WINAPI DLLExport actDeleteNode(LPRDATA rdPtr, long param1, long param2)
			{
				TiXmlNode*parNode=NULL;
				if(rdPtr->myNode!=NULL&&rdPtr->myNode->Parent()!=NULL)
				{
					parNode=rdPtr->myNode->Parent();
					parNode->RemoveChild(rdPtr->myNode);
					rdPtr->myNode=parNode;
				}
				else
				{
				}
				return 0;
			}
			//============================================================================
			//
			// EXPRESSIONS ROUTINES
			// 
			// ============================================================================
			
			
			long WINAPI DLLExport expressionGetFileName(LPRDATA rdPtr, long param1)
			{
				rdPtr->rHo.hoFlags |= HOF_STRING;
				return (long)rdPtr->myDoc->Value();
			}
			
			long WINAPI DLLExport expGetAutoNodeIndex(LPRDATA rdPtr, long param1)
			{
				return rdPtr->nodeindex-1;
			}
			
			long WINAPI DLLExport expNodeGetValue(LPRDATA rdPtr, long param1)
			{
				rdPtr->rHo.hoFlags |= HOF_STRING;
				if(rdPtr->myNode!=NULL)
				{
					return (long)rdPtr->myNode->Value();
				}
				else
				{
					return (long)"";
				}
			}
			
			long WINAPI DLLExport expNodeGetType(LPRDATA rdPtr, long param1)
			{
				if(rdPtr->myNode!=NULL)
				{
					return rdPtr->myNode->Type();
				}
				else
				{
					return -1;
				}
			}
			
			long WINAPI DLLExport expElemGetName(LPRDATA rdPtr, long param1)
			{
				rdPtr->rHo.hoFlags |= HOF_STRING;
				if(rdPtr->myNode!=NULL&&rdPtr->myNode->Type()==1)
				{
					return (long)rdPtr->myNode->ToElement()->Value();
				}
				else
				{
					return (long)"";
				}
			}
			
			long WINAPI DLLExport expElemGetAttribStr(LPRDATA rdPtr, long param1)
			{
				char * p1=(LPSTR)CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_STRING);
				rdPtr->rHo.hoFlags |= HOF_STRING;
				if(rdPtr->myNode!=NULL&&rdPtr->myNode->Type()==1&&rdPtr->myNode->ToElement()->Attribute(p1)!=NULL)
				{
					return (long)(rdPtr->myNode->ToElement()->Attribute(p1));
				}
				else
				{
					return (long)"";
				}
			}
			
			long WINAPI DLLExport expElemGetAttribVal(LPRDATA rdPtr, long param1)
			{
				char * p1=(LPSTR)CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_STRING);
				if(rdPtr->myNode!=NULL&&rdPtr->myNode->Type()==1&&rdPtr->myNode->ToElement()->Attribute(p1)!=NULL)
				{
					return atoi(rdPtr->myNode->ToElement()->Attribute(p1));
				}
				else
				{
					return 0;
				}
			}
			
			long WINAPI DLLExport expParentName(LPRDATA rdPtr, long param1)
			{
				rdPtr->rHo.hoFlags |= HOF_STRING;
				if(rdPtr->myNode!=NULL&&rdPtr->myNode->Parent()!=NULL&&rdPtr->myNode->Parent()->Type()==1)
				{
					return (long)rdPtr->myNode->Parent()->ToElement()->Value();
				}
				else
				{
					return (long)"";
				}
			}
			
			long WINAPI DLLExport expParentAttribStr(LPRDATA rdPtr, long param1)
			{
				char * p1=(LPSTR)CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_STRING);
				rdPtr->rHo.hoFlags |= HOF_STRING;
				if(rdPtr->myNode!=NULL&&rdPtr->myNode->Parent()!=NULL&&rdPtr->myNode->Parent()->Type()==1&&rdPtr->myNode->Parent()->ToElement()->Attribute(p1)!=NULL)
				{
					return (long)rdPtr->myNode->Parent()->ToElement()->Attribute(p1);
				}
				else
				{
					return (long)"";
				}
			}
			
			long WINAPI DLLExport expParentAttribVal(LPRDATA rdPtr, long param1)
			{
				char * p1=(LPSTR)CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_STRING);
				if(rdPtr->myNode!=NULL&&rdPtr->myNode->Parent()!=NULL&&rdPtr->myNode->Parent()->Type()==1&&rdPtr->myNode->Parent()->ToElement()->Attribute(p1)!=NULL)
				{
					return atoi(rdPtr->myNode->Parent()->ToElement()->Attribute(p1));
				}
				else
				{
					return 0;
				}
			}
			
			long WINAPI DLLExport expGetComStr(LPRDATA rdPtr, long param1)
			{
				rdPtr->rHo.hoFlags |= HOF_STRING;
				if(rdPtr->myNode!=NULL&&rdPtr->myNode->Type()==2)
				{
					return (long)rdPtr->myNode->ToComment()->Value();
				}
				else
				{
					return (long)"";
				}
			}
			
			long WINAPI DLLExport expGetText(LPRDATA rdPtr, long param1)
			{
				rdPtr->rHo.hoFlags |= HOF_STRING;
				if(rdPtr->myNode!=NULL&&rdPtr->myNode->Type()==4)
				{
					return (long)rdPtr->myNode->ToText()->Value();
				}
				else
				{
					return (long)"";
				}
			}
			
			long WINAPI DLLExport expUnknownGetText(LPRDATA rdPtr, long param1)
			{
				rdPtr->rHo.hoFlags |= HOF_STRING;
				if(rdPtr->myNode!=NULL&&rdPtr->myNode->Type()==3)
				{
					return (long)rdPtr->myNode->ToUnknown()->Value();
				}
				else
				{
					return (long)"";
				}
			}
			
			long WINAPI DLLExport expGetErrorStr(LPRDATA rdPtr, long param1)
			{
				rdPtr->rHo.hoFlags |= HOF_STRING;
				return (long)rdPtr->myDoc->ErrorDesc();
			}
			
			long WINAPI DLLExport expGetErrorID(LPRDATA rdPtr, long param1)
			{
				return rdPtr->myDoc->ErrorId();
			}
			
			long WINAPI DLLExport expGetErrorRow(LPRDATA rdPtr, long param1)
			{
				return rdPtr->myDoc->ErrorRow();
			}
			
			long WINAPI DLLExport expGetErrorCol(LPRDATA rdPtr, long param1)
			{
				return rdPtr->myDoc->ErrorCol();
			}
			long WINAPI DLLExport expGetDocText(LPRDATA rdPtr, long param1)
			{
				rdPtr->rHo.hoFlags |= HOF_STRING;
					TiXmlNode*Node;
					TiXmlString*buffer;
					buffer=new TiXmlString();
					Node=rdPtr->myDoc->FirstChild();
				if(Node!=NULL)
				{
					*buffer=get_xml_string(Node);
					while(Node->NextSibling()!=NULL)
					{
						Node=Node->NextSibling();
						(*buffer)+=get_xml_string(Node);
					}
				}
				return (long)(buffer->c_str());
			}
			long WINAPI DLLExport expGetChildText(LPRDATA rdPtr, long param1)
			{
				rdPtr->rHo.hoFlags |= HOF_STRING;
				TiXmlNode*host;
				if(rdPtr->myNode!=NULL&&rdPtr->myNode->FirstChild()!=NULL)
				{
					host=rdPtr->myNode->FirstChild();
					if(host->Type()==4)
					{
						return (long)host->ToText()->Value();
					}
					while(host->NextSibling()!=NULL)
					{
						host=host->NextSibling();
						if(host->Type()==4)
						{
						return (long)host->ToText()->Value();
						}
					}
				}
				return (long)"";
			}
			long WINAPI DLLExport expGetChildNum(LPRDATA rdPtr, long param1)
			{
				int count=0;
				TiXmlNode*host;
				if(rdPtr->myNode!=NULL&&rdPtr->myNode->FirstChild()!=NULL)
				{
					host=rdPtr->myNode->FirstChild();
					count++;
					while(host->NextSibling()!=NULL)
					{
						host=host->NextSibling();
						count++;
					}
				}
				return count;
			}
			long WINAPI DLLExport expGetParChildNum(LPRDATA rdPtr, long param1)
			{
				int count=0;
				TiXmlNode*host;
				if(rdPtr->myNode!=NULL&&rdPtr->myNode->Parent()!=NULL&&rdPtr->myNode->Parent()->FirstChild()!=NULL)
				{
					host=rdPtr->myNode->Parent()->FirstChild();
					count++;
					while(host->NextSibling()!=NULL)
					{
						host=host->NextSibling();
						count++;
					}
				}
				return count;
			}
			int CountIt(LPRDATA rdPtr,TiXmlNode*elem)
			{
				TiXmlNode *child=0;
				int Co=0;
				while(child=elem->IterateChildren(child))
				{
					//rdPtr->myNode=child;
					//element
					if(child->Type()==1)
					{
						Co++;
						Co+=CountIt(rdPtr,child);
					}
					else
					{
						Co++;
					}
				
				}
				return Co;
			}
			long WINAPI DLLExport expGetTotalNode(LPRDATA rdPtr, long param1)
			{
				int count=0;
				TiXmlNode*host;
				if(rdPtr->myNode!=NULL)
				{
					host=rdPtr->myDoc->FirstChild();
				if(host!=NULL)
				{
					count++;
					count+=CountIt(rdPtr,host);
					while(host->NextSibling()!=NULL)
					{
						host=host->NextSibling();	
						count++;
						count+=CountIt(rdPtr,host);
					}
				}
				}
				return count;
			}
			int TryPar(LPRDATA rdPtr,TiXmlNode*elem);
			int TryPrev(LPRDATA rdPtr,TiXmlNode*elem);
			int TryPar(LPRDATA rdPtr,TiXmlNode*elem)
			{
				//if the parent is a document
				if(elem->Type()==0)
				{
					//get the current count
					rdPtr->nodemainindex=rdPtr->nodemaincount;
				}
				else
				{
					rdPtr->nodemaincount++;
					TryPrev(rdPtr,elem);
				}
				return 0;
			}
			int TryPrev(LPRDATA rdPtr,TiXmlNode*elem)
			{
				//counts previous siblings
				while(elem->PreviousSibling()!=NULL)
				{
					elem=elem->PreviousSibling();
					rdPtr->nodemaincount+=CountIt(rdPtr,elem);
					rdPtr->nodemaincount++;
				}
				//after all siblings are gone and there is a parent
				if(elem->Parent()!=NULL)
				{
					//get the parent
					elem=elem->Parent();
					TryPar(rdPtr,elem);
				}
				return 0;

			}
			long WINAPI DLLExport expGetNodeIndex(LPRDATA rdPtr, long param1)
			{
				rdPtr->nodemaincount=0;
				rdPtr->nodemainindex=0;
				rdPtr->figurerun=true;
				TiXmlNode*host;
				if(rdPtr->myNode!=NULL)
				{
					host=rdPtr->myNode;
					TryPrev(rdPtr,host);

				}
				return rdPtr->nodemainindex-1;
				
			}
			long WINAPI DLLExport expGetNodeRelIndex(LPRDATA rdPtr, long param1)
			{
				TiXmlNode*hold;
				int sib=0;
				if(rdPtr->myNode!=NULL)
				{
					hold=rdPtr->myNode;
					while(hold->PreviousSibling()!=NULL)
					{
						sib++;
						hold=hold->PreviousSibling();
					}
					return sib;
				}
				return -1;
			}
			long WINAPI DLLExport expGetDepth(LPRDATA rdPtr, long param1)
			{
				TiXmlNode*hold;
				rdPtr->nodemaincount=0;
				rdPtr->nodemainindex=0;
				if(rdPtr->myNode!=NULL)
				{
				hold=rdPtr->myNode;
				while(hold->Parent()!=NULL)
				{
					hold=hold->Parent();
					if(hold->Type()==0)
					{
						rdPtr->nodemainindex=rdPtr->nodemaincount;
						break;
					}
					rdPtr->nodemaincount++;
				}
				return rdPtr->nodemainindex;
				}
				return -1;
			}
			long WINAPI DLLExport expAttribIndex(LPRDATA rdPtr,long param1)
			{
				return rdPtr->attribindex;
			}
			long WINAPI DLLExport expAttribName(LPRDATA rdPtr,long param1)
			{
				long p1=CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_INT);
				rdPtr->rHo.hoFlags |= HOF_STRING;
				TiXmlAttribute* sAttrib;
				int nodedep=0;
				if(rdPtr->myNode!=NULL&&rdPtr->myNode->Type()==1)
				{
					if(rdPtr->myNode->ToElement()->FirstAttribute()!=NULL)
					{
					sAttrib=rdPtr->myNode->ToElement()->FirstAttribute();
					if(p1==nodedep)
					{
						return (long)sAttrib->Name();
					}
					while(sAttrib->Next()!=NULL)
					{
						sAttrib=sAttrib->Next();
						nodedep++;
						if(p1==nodedep)
						{
							return (long)sAttrib->Name();
						}
					}
					}
				}
				return (long)""; 
			}
			long WINAPI DLLExport expAttribTotal(LPRDATA rdPtr,long param1)
			{
				TiXmlAttribute* sAttrib;
				int nodedep=0;
				if(rdPtr->myNode!=NULL&&rdPtr->myNode->Type()==1)
				{
					if(rdPtr->myNode->ToElement()->FirstAttribute()!=NULL)
					{
					sAttrib=rdPtr->myNode->ToElement()->FirstAttribute();
					nodedep++;
					while(sAttrib->Next()!=NULL)
					{
						sAttrib=sAttrib->Next();
						nodedep++;
					}
					return nodedep;
					}
					return 0;
				}
				return -1;
			}
			// ----------------------------------------------------------
			// Condition / Action / Expression jump table
			// ----------------------------------------------------------
			// Contains the address inside the extension of the different
			// routines that handle the action, conditions and expressions.
			// Located at the end of the source for convinience
			// Must finish with a 0
			//
			
			
			long (WINAPI * ConditionJumps[])(LPRDATA rdPtr, long param1, long param2) =
			{
				conLoadSuc,
					conOnElement,
					conOnComment,
					conOnUnknown,
					conOnText,
					conHasChild,
					conOnError,
					conOnAttrib,
					0
			};
			
			short (WINAPI * ActionJumps[])(LPRDATA rdPtr, long param1, long param2) =
			{
				actLoadFile,
					actSaveFile,
					actParse,
					actSetKey,
					actLoadEncFile,
					actSaveEncFile,
					actStartParsing,
					actStopParsing,
					actSetValue,
					actRoot,
					actFirstChild,
					actFindChild,
					actLastChild,
					actNextSibling,
					actFindSibling,
					actPreviousSibling,
					actParentNode,
					actDeleteChildren,
					actDeleteChild,
					actAddElem,
					actElemSetName,
					actElemAtribStr,
					actElemAtribVal,
					actAddCom,
					actSetCom,
					actAddText,
					actSetText,
					actClearError,
					actNodeIndex,
					actSibIndex,
					actChildIndex,
					actRemoveAttrib,
					actDeleteNode,
					0
			};
			
			long (WINAPI * ExpressionJumps[])(LPRDATA rdPtr, long param) =
			{
				expressionGetFileName,
					expGetAutoNodeIndex,
					expNodeGetValue,
					expNodeGetType,
					expElemGetName,
					expElemGetAttribStr,
					expElemGetAttribVal,
					expParentName,
					expParentAttribStr,
					expParentAttribVal,
					expGetComStr,
					expGetText,
					expUnknownGetText,
					expGetErrorStr,
					expGetErrorID,
					expGetErrorRow,
					expGetErrorCol,
					expGetDocText,
					expGetChildText,
					expGetChildNum,
					expGetParChildNum,
					expGetTotalNode,
					expGetNodeIndex,
					expGetNodeRelIndex,
					expGetDepth,
					expAttribIndex,
					expAttribName,
					expAttribTotal,
					0
			};
			
			
			