// ============================================================================
//
// This file is where the Conditions/Actions/Expressions are defined.
// Descriptions and jumptables are at the end of the file.
// If you add another a/c/e don't forget to update them!
//
// ============================================================================

// Common Include
#include	"common.h"


// ============================================================================
//
// CONDITION ROUTINES
// 
// ============================================================================



/* startfunc_c: conOnScroll */
long WINAPI DLLExport conOnScroll(LPRDATA rdPtr, long param1, long param2)
{
	return TRUE;
}
/* endfunc_c: conOnScroll */

/* startfunc_c: conHasFocus */
long WINAPI DLLExport conHasFocus(LPRDATA rdPtr, long param1, long param2)
{
	return rdPtr->Focus;
}
/* endfunc_c: conHasFocus */

/* startfunc_c: conIsEnabled */
long WINAPI DLLExport conIsEnabled(LPRDATA rdPtr, long param1, long param2)
{
	return rdPtr->Enabled;
}
/* endfunc_c: conIsEnabled */

/* startfunc_c: conIsVisible */
long WINAPI DLLExport conIsVisible(LPRDATA rdPtr, long param1, long param2)
{
	return rdPtr->Visible;
}
/* endfunc_c: conIsVisible */

// ============================================================================
//
// ACTIONS ROUTINES
// 
// ============================================================================



/* startfunc_a: actSetScrollPosition */
short WINAPI DLLExport actSetScrollPosition(LPRDATA rdPtr, long param1, long param2)
{
	long p1 = CNC_GetIntParameter(rdPtr);// Position
	if(rdPtr->Enabled==true)
	{
	SetScrollPos(rdPtr->mWin,SB_CTL,p1,true);
	callRunTimeFunction(rdPtr, RFUNCTION_GENERATEEVENT, 0, 0);
	}
	return 0;
}
/* endfunc_a: actSetScrollPosition */

/* startfunc_a: actSetScrollRange */
short WINAPI DLLExport actSetScrollRange(LPRDATA rdPtr, long param1, long param2)
{
	long p1 = CNC_GetIntParameter(rdPtr);			// Minimum
	long p2 = CNC_GetIntParameter(rdPtr);			// Maximum
	rdPtr->minval=p1;
	rdPtr->maxval=p2;
	rdPtr->si.fMask  = SIF_RANGE;
	rdPtr->si.nMin   =rdPtr->minval;
	rdPtr->si.nMax   =rdPtr->maxval+9;
	if(rdPtr->Enabled==true)
	{
	SetScrollInfo(rdPtr->mWin, SB_CTL, &rdPtr->si, TRUE);
	callRunTimeFunction(rdPtr, RFUNCTION_GENERATEEVENT, 0, 0);
	}
	return 0;
}
/* endfunc_a: actSetScrollRange */

/* startfunc_a: actSetSmallChange */
short WINAPI DLLExport actSetSmallChange(LPRDATA rdPtr, long param1, long param2)
{
	long p1 = CNC_GetIntParameter(rdPtr);			// Small Change
	rdPtr->smallchange=p1;
	return 0;
}
/* endfunc_a: actSetSmallChange */

/* startfunc_a: actSetLargeChange */
short WINAPI DLLExport actSetLargeChange(LPRDATA rdPtr, long param1, long param2)
{
	long p1 = CNC_GetIntParameter(rdPtr);			// Large Change
	rdPtr->largechange=p1;
	return 0;
}
/* endfunc_a: actSetLargeChange */

/* startfunc_a: actFocusOn */
short WINAPI DLLExport actFocusOn(LPRDATA rdPtr, long param1, long param2)
{
	SendMessage(rdPtr->mWin,WM_SETFOCUS,NULL,NULL);
	return 0;
}
/* endfunc_a: actFocusOn */

/* startfunc_a: actFocusOff */
short WINAPI DLLExport actFocusOff(LPRDATA rdPtr, long param1, long param2)
{
	SendMessage(rdPtr->mWin,WM_KILLFOCUS,NULL,NULL);
	return 0;
}
/* endfunc_a: actFocusOff */

/* startfunc_a: actEnableOn */
short WINAPI DLLExport actEnableOn(LPRDATA rdPtr, long param1, long param2)
{
	EnableScrollBar(rdPtr->mWin,SB_CTL,ESB_ENABLE_BOTH);
	rdPtr->Enabled=true;
	SetScrollPos(rdPtr->mWin,SB_CTL,GetScrollPos(rdPtr->mWin,SB_CTL),true);
	return 0;
}
/* endfunc_a: actEnableOn */

/* startfunc_a: actEnableOff */
short WINAPI DLLExport actEnableOff(LPRDATA rdPtr, long param1, long param2)
{
	EnableScrollBar(rdPtr->mWin,SB_CTL,ESB_DISABLE_BOTH);
	rdPtr->Enabled=false;
	return 0;
}
/* endfunc_a: actEnableOff */

/* startfunc_a: actSetSize */
short WINAPI DLLExport actSetSize(LPRDATA rdPtr, long param1, long param2)
{
	long p1 = CNC_GetIntParameter(rdPtr);			// Width
	long p2 = CNC_GetIntParameter(rdPtr);			// Height
	rdPtr->wid=p1;
	rdPtr->hei=p2;
		rdPtr->rHo.hoImgWidth =rdPtr->wid; 
	rdPtr->rHo.hoImgHeight = rdPtr->hei; 
	MoveWindow(rdPtr->mWin,rdPtr->px - rdPtr->rHo.hoAdRunHeader->rhWindowX,rdPtr->py - rdPtr->rHo.hoAdRunHeader->rhWindowY,rdPtr->wid,rdPtr->hei,true);
	return 0;
}
/* endfunc_a: actSetSize */

/* startfunc_a: actSetWidth */
short WINAPI DLLExport actSetWidth(LPRDATA rdPtr, long param1, long param2)
{
	long p1 = CNC_GetIntParameter(rdPtr);			// Width
		rdPtr->rHo.hoImgWidth =rdPtr->wid; 
	rdPtr->wid=p1;
	MoveWindow(rdPtr->mWin,rdPtr->px - rdPtr->rHo.hoAdRunHeader->rhWindowX,rdPtr->py - rdPtr->rHo.hoAdRunHeader->rhWindowY,rdPtr->wid,rdPtr->hei,true);
	return 0;
}
/* endfunc_a: actSetWidth */

/* startfunc_a: actSetHeight */
short WINAPI DLLExport actSetHeight(LPRDATA rdPtr, long param1, long param2)
{
	long p1 = CNC_GetIntParameter(rdPtr);			// Height
	rdPtr->hei=p1;
	rdPtr->rHo.hoImgHeight = rdPtr->hei;
	MoveWindow(rdPtr->mWin,rdPtr->px - rdPtr->rHo.hoAdRunHeader->rhWindowX,rdPtr->py - rdPtr->rHo.hoAdRunHeader->rhWindowY,rdPtr->wid,rdPtr->hei,true);
	return 0;
}
short WINAPI DLLExport actVisOn(LPRDATA rdPtr,long param1,long param2)
{
	rdPtr->Visible=true;
	ShowScrollBar(rdPtr->mWin,SB_CTL,rdPtr->Visible);
	return 0;
}
short WINAPI DLLExport actVisOff(LPRDATA rdPtr,long param1,long param2)
{
	rdPtr->Visible=false;
	ShowScrollBar(rdPtr->mWin,SB_CTL,rdPtr->Visible);
	return 0;
}
/* endfunc_a: actSetHeight */

// ============================================================================
//
// EXPRESSIONS ROUTINES
// 
// ============================================================================



/* startfunc_e: expGetValue */
long WINAPI DLLExport expGetValue(LPRDATA rdPtr, long param1)
{
	return GetScrollPos(rdPtr->mWin, SB_CTL);;
}
/* endfunc_e: expGetValue */

/* startfunc_e: expGetMinVal */
long WINAPI DLLExport expGetMinVal(LPRDATA rdPtr, long param1)
{
	return rdPtr->minval;
}
/* endfunc_e: expGetMinVal */

/* startfunc_e: expGetMaxVal */
long WINAPI DLLExport expGetMaxVal(LPRDATA rdPtr, long param1)
{
	return rdPtr->maxval;
}
/* endfunc_e: expGetMaxVal */

/* startfunc_e: expGetSmallChange */
long WINAPI DLLExport expGetSmallChange(LPRDATA rdPtr, long param1)
{
	return rdPtr->smallchange;
}
/* endfunc_e: expGetSmallChange */

/* startfunc_e: expGetLargeChange */
long WINAPI DLLExport expGetLargeChange(LPRDATA rdPtr, long param1)
{
	return rdPtr->largechange;
}
/* endfunc_e: expGetLargeChange */

/* startfunc_e: expGetWidth */
long WINAPI DLLExport expGetWidth(LPRDATA rdPtr, long param1)
{
	return rdPtr->wid;
}
/* endfunc_e: expGetWidth */

/* startfunc_e: expGetHeight */
long WINAPI DLLExport expGetHeight(LPRDATA rdPtr, long param1)
{
	return rdPtr->hei;
}
/* endfunc_e: expGetHeight */

// Quick memo: content of the eventInformations arrays
// ---------------------------------------------------
// Menu ID
// String ID
// Code
// Flags
// Number_of_parameters
// Parameter_type [Number_of_parameters]
// Parameter_TitleString [Number_of_parameters]

// Definitions of parameters for each condition
short conditionsInfos[]=
		{
		IDMN_CONONSCROLL,	IDS_CONONSCROLL,	CND_CONONSCROLL,	0,	0,
		IDMN_CONHASFOCUS,	IDS_CONHASFOCUS,	CND_CONHASFOCUS,	EVFLAGS_ALWAYS | EVFLAGS_NOTABLE,	0,
		IDMN_CONISENABLED,	IDS_CONISENABLED,	CND_CONISENABLED,	EVFLAGS_ALWAYS | EVFLAGS_NOTABLE,	0,
		IDMN_CONISVISIBLE,	IDS_CONISVISIBLE,	CND_CONISVISIBLE,	EVFLAGS_ALWAYS | EVFLAGS_NOTABLE,	0,
		};

// Definitions of parameters for each action
short actionsInfos[]=
		{
		IDMN_ACTSETSCROLLPOSITION,	IDS_ACTSETSCROLLPOSITION,	ACT_ACTSETSCROLLPOSITION,	0,	1,	PARAM_EXPRESSION,	IDS_ACTSETSCROLLPOSITION_P0,
		IDMN_ACTSETSCROLLRANGE,	IDS_ACTSETSCROLLRANGE,	ACT_ACTSETSCROLLRANGE,	0,	2,	PARAM_EXPRESSION,	PARAM_EXPRESSION,	IDS_ACTSETSCROLLRANGE_P0,	IDS_ACTSETSCROLLRANGE_P1,
		IDMN_ACTSETSMALLCHANGE,	IDS_ACTSETSMALLCHANGE,	ACT_ACTSETSMALLCHANGE,	0,	1,	PARAM_EXPRESSION,	IDS_ACTSETSMALLCHANGE_P0,
		IDMN_ACTSETLARGECHANGE,	IDS_ACTSETLARGECHANGE,	ACT_ACTSETLARGECHANGE,	0,	1,	PARAM_EXPRESSION,	IDS_ACTSETLARGECHANGE_P0,
		IDMN_ACTFOCUSON,	IDS_ACTFOCUSON,	ACT_ACTFOCUSON,	0,	0,
		IDMN_ACTFOCUSOFF,	IDS_ACTFOCUSOFF,	ACT_ACTFOCUSOFF,	0,	0,
		IDMN_ACTENABLEON,	IDS_ACTENABLEON,	ACT_ACTENABLEON,	0,	0,
		IDMN_ACTENABLEOFF,	IDS_ACTENABLEOFF,	ACT_ACTENABLEOFF,	0,	0,
		IDMN_ACTSETSIZE,	IDS_ACTSETSIZE,	ACT_ACTSETSIZE,	0,	2,	PARAM_EXPRESSION,	PARAM_EXPRESSION,	IDS_ACTSETSIZE_P0,	IDS_ACTSETSIZE_P1,
		IDMN_ACTSETWIDTH,	IDS_ACTSETWIDTH,	ACT_ACTSETWIDTH,	0,	1,	PARAM_EXPRESSION,	IDS_ACTSETWIDTH_P0,
		IDMN_ACTSETHEIGHT,	IDS_ACTSETHEIGHT,	ACT_ACTSETHEIGHT,	0,	1,	PARAM_EXPRESSION,	IDS_ACTSETHEIGHT_P0,
		IDMN_ACTVISON,IDS_ACTVISON,ACT_ACTVISON,0,0,
		IDMN_ACTVISOFF,IDS_ACTVISOFF,ACT_ACTVISOFF,0,0,
		};

// Definitions of parameters for each expression
short expressionsInfos[]=
		{
		IDMN_EXPGETVALUE,	IDS_EXPGETVALUE,	EXP_EXPGETVALUE,	0,	0,
		IDMN_EXPGETMINVAL,	IDS_EXPGETMINVAL,	EXP_EXPGETMINVAL,	0,	0,
		IDMN_EXPGETMAXVAL,	IDS_EXPGETMAXVAL,	EXP_EXPGETMAXVAL,	0,	0,
		IDMN_EXPGETSMALLCHANGE,	IDS_EXPGETSMALLCHANGE,	EXP_EXPGETSMALLCHANGE,	0,	0,
		IDMN_EXPGETLARGECHANGE,	IDS_EXPGETLARGECHANGE,	EXP_EXPGETLARGECHANGE,	0,	0,
		IDMN_EXPGETWIDTH,	IDS_EXPGETWIDTH,	EXP_EXPGETWIDTH,	0,	0,
		IDMN_EXPGETHEIGHT,	IDS_EXPGETHEIGHT,	EXP_EXPGETHEIGHT,	0,	0,
		};


// ----------------------------------------------------------
// Condition / Action / Expression jump table
// ----------------------------------------------------------
// Contains the address inside the extension of the different
// routines that handle the action, conditions and expressions.
// Located at the end of the source for convinience
// Must finish with a 0
//
long (WINAPI * ConditionJumps[])(LPRDATA rdPtr, long param1, long param2) = 
			{ 
			conOnScroll,
			conHasFocus,
			conIsEnabled,
			conIsVisible,
			0
			};
	
short (WINAPI * ActionJumps[])(LPRDATA rdPtr, long param1, long param2) =
			{
			actSetScrollPosition,
			actSetScrollRange,
			actSetSmallChange,
			actSetLargeChange,
			actFocusOn,
			actFocusOff,
			actEnableOn,
			actEnableOff,
			actSetSize,
			actSetWidth,
			actSetHeight,
			actVisOn,
			actVisOff,
			0
			};

long (WINAPI * ExpressionJumps[])(LPRDATA rdPtr, long param) = 
			{     
			expGetValue,
			expGetMinVal,
			expGetMaxVal,
			expGetSmallChange,
			expGetLargeChange,
			expGetWidth,
			expGetHeight,
			0
			};