// ============================================================================
//
// This file is where the Conditions/Actions/Expressions are defined.
// Descriptions and jumptables are at the end of the file.
// If you add another a/c/e don't forget to update them!
//
// ============================================================================

// Common Include
#include	"common.h"


// ============================================================================
//
// CONDITION ROUTINES
// 
// ============================================================================



/* startfunc_c: conOnCommunication */
long WINAPI DLLExport conOnCommunication(LPRDATA rdPtr, long param1, long param2)
{
	long p1 = CNC_GetIntParameter(rdPtr);			// Port Number (1-4)
	if(rdPtr->mCurPort==p1)
		return TRUE;
	return FALSE;
}
/* endfunc_c: conOnCommunication */

/* startfunc_c: conOnCTS */
long WINAPI DLLExport conOnCTS(LPRDATA rdPtr, long param1, long param2)
{
	long p1 = CNC_GetIntParameter(rdPtr);			// Port Number (1-4)
	if(rdPtr->mCurPort==p1)
		return TRUE;
	return FALSE;
}
/* endfunc_c: conOnCTS */

/* startfunc_c: conOnError */
long WINAPI DLLExport conOnError(LPRDATA rdPtr, long param1, long param2)
{

	return TRUE;
}
/* endfunc_c: conOnError */

// ============================================================================
//
// ACTIONS ROUTINES
// 
// ============================================================================



/* startfunc_a: actInitPort */
short WINAPI DLLExport actInitPort(LPRDATA rdPtr, long param1, long param2)
{
	long p1 =CNC_GetIntParameter(rdPtr);				// Port Number (1-4)
	long p2 = CNC_GetIntParameter(rdPtr);			// Baud Rate
	long p3 = CNC_GetIntParameter(rdPtr);				// Data Bits
	long p4 = CNC_GetIntParameter(rdPtr);				// Stop Bits
	long p5 = CNC_GetIntParameter(rdPtr);				// Buffer Size
	if(p1>0&&p1<5)
	{
		if(rdPtr->mPorts[p1-1].InitPort(rdPtr->rHo.hoAdRunHeader->rhHEditWin,p1,p2,'N',p3,p4,EV_RXCHAR | EV_CTS,p5))
		{
			rdPtr->mPorts[p1-1].StartMonitoring();
		}
		else
		{
			rdPtr->mError="Port not found!";
			callRunTimeFunction(rdPtr, RFUNCTION_GENERATEEVENT, CND_CONONERROR, 0);
		}
	}
	else
	{
		rdPtr->mError="Port out of range!";
		callRunTimeFunction(rdPtr, RFUNCTION_GENERATEEVENT, CND_CONONERROR, 0);
	}
	return 0;
}
/* endfunc_a: actInitPort */

/* startfunc_a: actStartMonitor */
short WINAPI DLLExport actStartMonitor(LPRDATA rdPtr, long param1, long param2)
{
	long p1 =CNC_GetIntParameter(rdPtr);				// Port Number (1-4)
	if(p1>0&&p1<5)
	{
		rdPtr->mPorts[p1-1].StartMonitoring();
	}
	else
	{
		rdPtr->mError="Port out of range!";
		callRunTimeFunction(rdPtr, RFUNCTION_GENERATEEVENT, CND_CONONERROR, 0);
	}
	return 0;
}
/* endfunc_a: actStartMonitor */

/* startfunc_a: actRestartMonitor */
short WINAPI DLLExport actRestartMonitor(LPRDATA rdPtr, long param1, long param2)
{
	long p1 =CNC_GetIntParameter(rdPtr);				// Port Number (1-4)
	if(p1>0&&p1<5)
	{
		rdPtr->mPorts[p1-1].RestartMonitoring();
	}
	else
	{
		rdPtr->mError="Port out of range!";
		callRunTimeFunction(rdPtr, RFUNCTION_GENERATEEVENT, CND_CONONERROR, 0);
	}
	return 0;
}
/* endfunc_a: actRestartMonitor */

/* startfunc_a: actStopMonitor */
short WINAPI DLLExport actStopMonitor(LPRDATA rdPtr, long param1, long param2)
{
	long p1 =CNC_GetIntParameter(rdPtr);				// Port Number (1-4)
	if(p1>0&&p1<5)
	{
		rdPtr->mPorts[p1-1].StopMonitoring();
	}
	else
	{
		rdPtr->mError="Port out of range!";
		callRunTimeFunction(rdPtr, RFUNCTION_GENERATEEVENT, CND_CONONERROR, 0);
	}
	return 0;
}
/* endfunc_a: actStopMonitor */

/* startfunc_a: actWriteToPort */
short WINAPI DLLExport actWriteToPort(LPRDATA rdPtr, long param1, long param2)
{
	long p1 = CNC_GetIntParameter(rdPtr);			// Port Number (1-4)
	char* p2 = reinterpret_cast<char*>(CNC_GetParameter(rdPtr));	// Text
	if(p1>0&&p1<5)
		rdPtr->mPorts[p1-1].WriteToPort(p2);
	else
	{
		rdPtr->mError="Port out of range";
		callRunTimeFunction(rdPtr, RFUNCTION_GENERATEEVENT, CND_CONONERROR, 0);
	}
	return 0;
}
/* endfunc_a: actWriteToPort */

// ============================================================================
//
// EXPRESSIONS ROUTINES
// 
// ============================================================================



/* startfunc_e: expGetRecvText */
long WINAPI DLLExport expGetRecvText(LPRDATA rdPtr, long param1)
{
	long p1 = CNC_GetFirstExpressionParameter(rdPtr, param1, TYPE_INT);				// Port
	rdPtr->rHo.hoFlags |= HOF_STRING;
	char*retStr="";
	if(p1>0&&p1<5)
	{
	retStr=(char*)(rdPtr->mBuffer[p1-1].c_str());
	}
	else
	{
		rdPtr->mError="Port out of range";
		callRunTimeFunction(rdPtr, RFUNCTION_GENERATEEVENT, CND_CONONERROR, 0);
	}
	// Return string

	return reinterpret_cast<long>(retStr);
}
/* endfunc_e: expGetRecvText */

/* startfunc_e: expGetCurPort */
long WINAPI DLLExport expGetCurPort(LPRDATA rdPtr, long param1)
{
	return rdPtr->mCurPort;
}
/* endfunc_e: expGetCurPort */

/* startfunc_e: expGetErrorMsg */
long WINAPI DLLExport expGetErrorMsg(LPRDATA rdPtr, long param1)
{
	rdPtr->rHo.hoFlags |= HOF_STRING;
	char*	retStr = "";
	retStr=(char*)rdPtr->mError.c_str();
	// Return string
	return reinterpret_cast<long>(retStr);
}
/* endfunc_e: expGetErrorMsg */

// Quick memo: content of the eventInformations arrays
// ---------------------------------------------------
// Menu ID
// String ID
// Code
// Flags
// Number_of_parameters
// Parameter_type [Number_of_parameters]
// Parameter_TitleString [Number_of_parameters]

// Definitions of parameters for each condition
short conditionsInfos[]=
		{
		IDMN_CONONCOMMUNICATION,	IDS_CONONCOMMUNICATION,	CND_CONONCOMMUNICATION,	0,	1,	PARAM_EXPRESSION,	IDS_CONONCOMMUNICATION_P0,
		IDMN_CONONCTS,	IDS_CONONCTS,	CND_CONONCTS,	0,	1,	PARAM_EXPRESSION,	IDS_CONONCTS_P0,
		IDMN_CONONERROR,	IDS_CONONERROR,	CND_CONONERROR,	0,	0,
		};

// Definitions of parameters for each action
short actionsInfos[]=
		{
		IDMN_ACTINITPORT,	IDS_ACTINITPORT,	ACT_ACTINITPORT,	0,	5,	PARAM_EXPRESSION,	PARAM_EXPRESSION,	PARAM_EXPRESSION,	PARAM_EXPRESSION,	PARAM_EXPRESSION,	IDS_ACTINITPORT_P0,	IDS_ACTINITPORT_P1,	IDS_ACTINITPORT_P2,	IDS_ACTINITPORT_P3,	IDS_ACTINITPORT_P4,
		IDMN_ACTSTARTMONITOR,	IDS_ACTSTARTMONITOR,	ACT_ACTSTARTMONITOR,	0,	1,PARAM_EXPRESSION,IDS_ACTINITPORT_P0,
		IDMN_ACTRESTARTMONITOR,	IDS_ACTRESTARTMONITOR,	ACT_ACTRESTARTMONITOR,	0,	1,PARAM_EXPRESSION,IDS_ACTINITPORT_P0,
		IDMN_ACTSTOPMONITOR,	IDS_ACTSTOPMONITOR,	ACT_ACTSTOPMONITOR,	0,	1,PARAM_EXPRESSION,IDS_ACTINITPORT_P0,
		IDMN_ACTWRITETOPORT,	IDS_ACTWRITETOPORT,	ACT_ACTWRITETOPORT,	0,	2,	PARAM_EXPRESSION,	PARAM_EXPSTRING,	IDS_ACTWRITETOPORT_P0,	IDS_ACTWRITETOPORT_P1,
		};

// Definitions of parameters for each expression
short expressionsInfos[]=
		{
		IDMN_EXPGETRECVTEXT,	IDS_EXPGETRECVTEXT,	EXP_EXPGETRECVTEXT,	EXPFLAG_STRING,	1,	EXPPARAM_LONG,	IDS_EXPGETRECVTEXT_P0,
		IDMN_EXPGETCURPORT,	IDS_EXPGETCURPORT,	EXP_EXPGETCURPORT,	0,	0,
		IDMN_EXPGETERRORMSG,	IDS_EXPGETERRORMSG,	EXP_EXPGETERRORMSG,	EXPFLAG_STRING,	0,
		};


// ----------------------------------------------------------
// Condition / Action / Expression jump table
// ----------------------------------------------------------
// Contains the address inside the extension of the different
// routines that handle the action, conditions and expressions.
// Located at the end of the source for convinience
// Must finish with a 0
//
long (WINAPI * ConditionJumps[])(LPRDATA rdPtr, long param1, long param2) = 
			{ 
			conOnCommunication,
			conOnCTS,
			conOnError,
			0
			};
	
short (WINAPI * ActionJumps[])(LPRDATA rdPtr, long param1, long param2) =
			{
			actInitPort,
			actStartMonitor,
			actRestartMonitor,
			actStopMonitor,
			actWriteToPort,
			0
			};

long (WINAPI * ExpressionJumps[])(LPRDATA rdPtr, long param) = 
			{     
			expGetRecvText,
			expGetCurPort,
			expGetErrorMsg,
			0
			};