#include "DynProp.hpp"
//
// Dynamic property data storage
// for storing variable-length strings in your EDITDATA
// Add new IDs for which you wish to store data in DynProp.hpp;
// make sure DynamicProp_End is last or you will have serious problems.
//
// Created by Chris Branch, 2006. This file and DynProp.hpp are public domain.
//

const void* getDynamicProp(EDITDATA* edPtr, EditDataDynamicProps propType) {
	if (propType == DynamicProp_End)	// invalid index
		return 0;
	char* propStart = reinterpret_cast<char*>(edPtr)+sizeof(EDITDATA);
	int* propOffset = reinterpret_cast<int*>(propStart) + static_cast<int>(propType);
	return propStart+*propOffset;
}

int getDynamicPropLen(EDITDATA* edPtr, EditDataDynamicProps propType) {
	if (propType == DynamicProp_End)	// invalid index
		return 0;
	char* propStart = reinterpret_cast<char*>(edPtr)+sizeof(EDITDATA);
	int* propOffset = reinterpret_cast<int*>(propStart) + static_cast<int>(propType);
	return *(propOffset+1) - *propOffset;
}

const void* setDynamicProp(EDITDATA* &edPtr, EditDataDynamicProps propType, const void* data, int dataLen, mv _far *mV) {
	if (propType == DynamicProp_End)	// invalid index
		return 0;
	char* propStart = reinterpret_cast<char*>(edPtr)+sizeof(EDITDATA);
	int propDataSize = *(reinterpret_cast<int*>(propStart) + DynamicProp_End);
	int* propOffset = reinterpret_cast<int*>(propStart) + static_cast<int>(propType);
	
	if ((*(propOffset+1) - *propOffset) == dataLen)	{	// Same size?
		memcpy(propStart+*propOffset, data, dataLen);
		return propStart+*propOffset;
	} else {
		int lengthDiff = dataLen - *(propOffset+1) + *propOffset;
		// Reallocate editdata structure - add length difference to data size
		EDITDATA* newEdPtr = (LPEDATA)mvReAllocEditData(mV, edPtr, sizeof(EDITDATA) + propDataSize + lengthDiff);
		if (newEdPtr == 0)	// allocation failed
			return 0;
		// Update with new edPtr
		edPtr = newEdPtr;
		// Now our pointers are invalid; update them
		propStart = reinterpret_cast<char*>(edPtr)+sizeof(EDITDATA);
		propOffset = reinterpret_cast<int*>(propStart) + static_cast<int>(propType);
		// Move old memory following this ID
		memmove(propStart + *(propOffset+1) + lengthDiff, propStart + *(propOffset+1), propDataSize - *(propOffset+1));	// propDataSize = old size
		// Update following offsets
		{ for (int* iterOffset = propOffset+1; iterOffset <= (reinterpret_cast<int*>(propStart) + DynamicProp_End); iterOffset++) {
			*iterOffset += lengthDiff;
		} }
		// Copy new data
		memcpy(propStart + *propOffset, data, dataLen);

		return propStart + *propOffset;
	}
}

bool initDynamicProp(EDITDATA* &edPtr, mv _far *mV) {
	// Allocate editdata structure with necessary space.
	// 2 null bytes are allocated for each field (assume they are wide strings, in anticipation of MMF unicode support ;P)
	EDITDATA* newEdPtr = (LPEDATA)mvReAllocEditData(mV, edPtr, sizeof(EDITDATA) + (DynamicProp_End+1) * sizeof(int) + DynamicProp_End * 2);
	if (newEdPtr == 0)	// allocation failed
		return false;

	edPtr = newEdPtr;

	// Go ahead and init the values
	char* propStart = reinterpret_cast<char*>(edPtr)+sizeof(EDITDATA);
	int propDataStart = (DynamicProp_End+1) * sizeof(int);
	int* propOffset = reinterpret_cast<int*>(propStart);
	// Init offsets
	{ for (int i = 0; i <= DynamicProp_End; i++) {
		*(propOffset+i) = propDataStart + (i * 2);
	} }
	// Zero data bytes
	memset(propStart + (DynamicProp_End+1) * sizeof(int), 0, DynamicProp_End * 2);

	return true;
}